package com.thebeastshop.pegasus.component.price;

import java.math.BigDecimal;
import java.util.Map;

import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.cart.ProductPack;;
import com.thebeastshop.support.AccessWay;

/**
 * 计算商品价格的上下文。
 * 展示价格时用PriceCalculateContextForProduct，下单时用PriceCalculateContextForOrder
 *
 * @author Liang Wenjian
 */
public interface PriceCalculateContext {

	MemberVO getMember();

	AccessWay getAccessWay();

	Channel getChannel();

	Map<ProductPack, BigDecimal> getPackAndOriginalPrice();

}
