package com.thebeastshop.pegasus.component.price;

import java.math.BigDecimal;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.impl.FullCutCouponImpl;
import com.thebeastshop.cart.ProductPack;;

/**
 * 当用来展示商品时，不需要计算优惠券的优惠 当用来展示订单信息、下单时需要计算优惠券的优惠。
 *
 * @author Liang Wenjian
 */
@Component
public class CouponPriceCalculator implements PriceCalculator {

	public CouponPriceCalculator() {
		super();
	}

	@Override
	public Map<ProductPack, BigDecimal> calculate(final PriceCalculateContext context) {
		final Map<ProductPack, BigDecimal> prePriceMap = context.getPackAndOriginalPrice();
		if (context instanceof PriceCalculateContextForOrder) {
			final PriceCalculateContextForOrder priceCalculateContextForOrder = (PriceCalculateContextForOrder) context;
			final Coupon coupon = priceCalculateContextForOrder.getCoupon();
			if (coupon instanceof FullCutCouponImpl) {
				// 目前只有一种优惠券：满减优惠券
				// TODO:以后把下面的算法统一放到DiscountType里去。
				final FullCutCouponImpl fullCutCoupon = (FullCutCouponImpl) coupon;
				final BigDecimal savedPrice = fullCutCoupon.getCutPrice();
				return PriceCalculatorUtil.shareDiscount(savedPrice, prePriceMap);
			}
		}
		return prePriceMap;
	}

	@Override
	public int getOrder() {
		return LOWEST_PRECEDENCE;
	}
}
