package com.thebeastshop.pegasus.component.delivery.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.delivery.dao.DeliveryDistrictDao;
import com.thebeastshop.pegasus.component.delivery.enums.DeliveryType;
import com.thebeastshop.pegasus.component.delivery.service.DeliveryDistrictService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.model.CommDistrict;

/**
 * 配送区域服务实现
 * 
 * @author Paul-xiong
 *
 */
@Service
public class DeliveryDistrictServiceImpl implements DeliveryDistrictService {

	/**
	 * 联邦快递针对某些地区不配送
	 */
	private static List<String> fedexNotDeliveryAreas = new ArrayList<String>();

	/**
	 * 商品可配送地址
	 */
	private static Map<String,List<String>> prodCodeDeliveryAreas = new HashMap<>();

	static {
		fedexNotDeliveryAreas.add("石景山区");
		fedexNotDeliveryAreas.add("门头沟区");
		fedexNotDeliveryAreas.add("房山区");
		fedexNotDeliveryAreas.add("昌平区");
		fedexNotDeliveryAreas.add("大兴区");
		fedexNotDeliveryAreas.add("怀柔区");
		fedexNotDeliveryAreas.add("平谷区");
		fedexNotDeliveryAreas.add("密云县");
		fedexNotDeliveryAreas.add("延庆县");

		prodCodeDeliveryAreas.put("PROD001019595",Lists.<String>newArrayList("上海","北京"));
		prodCodeDeliveryAreas.put("PROD001019596",Lists.<String>newArrayList("上海","北京"));
		prodCodeDeliveryAreas.put("PROD001019635",Lists.<String>newArrayList("上海","北京"));
		prodCodeDeliveryAreas.put("PROD001019636",Lists.<String>newArrayList("上海","北京"));


	}

	@Autowired
	private DeliveryDistrictDao dao;

	@Override
	public boolean checkDelivery(DeliveryType type, long districtId) {
		if (type != null) {
			List<DeliveryType> types = Lists.newArrayList(type);
			if (type.equals(DeliveryType.FEDEX)) {
				CommDistrict district = PegasusUtilFacade.getInstance().findDistrictById(districtId);
				if (fedexNotDeliveryAreas.contains(district.getName())) {
					return false;
				}
				types.add(DeliveryType.SELF);
			}
			List<Long> districtIds = dao.getDistrictIds(types);
			if (districtIds.contains(districtId)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean checkDelivery(String productCode, long districtId) {
		boolean flag = true;
		if(prodCodeDeliveryAreas.containsKey(productCode)){
			List<String> deliveryAreas = prodCodeDeliveryAreas.get(productCode);
			CommDistrict district = PegasusUtilFacade.getInstance().findDistrictById(districtId);
			String districtFullName = district.getFullName();
			flag = false;
			for(String s :deliveryAreas){
				if(districtFullName.contains(s)){
					return true;
				}
			}
		}
		return flag;
	}

}
