package com.thebeastshop.pegasus.component.delivery.service;

import com.thebeastshop.pegasus.component.delivery.enums.DeliveryType;

/**
 * 配送区域服务
 * 
 * @author Paul-xiong
 *
 */
public interface DeliveryDistrictService {

	/**
	 * 判断地区是否可配送
	 * 
	 * @param type
	 *            配送类型
	 * @param districtId
	 *            地区id
	 * @return
	 */
	boolean checkDelivery(DeliveryType type, long districtId);

	/**
	 * 判断地址是否可送，只校验配置可送区域的商品
	 * @param productCode
	 * @param districtId
	 * @return
	 */
	boolean checkDelivery(String productCode, long districtId);

}
