package com.thebeastshop.pegasus.component.delivery.dao.impl;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.delivery.dao.DeliveryDistrictDao;
import com.thebeastshop.pegasus.component.delivery.dao.mapper.DeliveryDistrictEntityMapper;
import com.thebeastshop.pegasus.component.delivery.enums.DeliveryType;
import com.thebeastshop.pegasus.component.delivery.model.DeliveryDistrictEntity;
import com.thebeastshop.pegasus.component.delivery.model.DeliveryDistrictEntityExample;
import com.thebeastshop.pegasus.component.delivery.model.DeliveryDistrictEntityExample.Criteria;

/**
 * 配送区域服务实现
 * 
 * @author Paul-xiong
 *
 */
@Repository
public class DeliveryDistrictDaoImpl implements DeliveryDistrictDao {

	@Autowired
	private DeliveryDistrictEntityMapper mapper;

	@Override
	public List<Long> getDistrictIds(DeliveryType type) {
		List<Long> ids = Lists.newArrayList();
		if(type !=null){
			DeliveryDistrictEntityExample example = new DeliveryDistrictEntityExample();
			Criteria criteria = example.createCriteria();
			criteria.andFlowerDevTypeEqualTo(type.getId().shortValue());
			criteria.andPcsTypeEqualTo(Byte.valueOf("3"));// TODO:pcsType为3表示取区信息
			List<DeliveryDistrictEntity> entities = this.mapper.selectByExample(example);
			for (DeliveryDistrictEntity entity : entities) {
				ids.add(entity.getOeId());// TODO:目前先用oeId, 以后这张表要改的吧
			}
		}
		return ids;
	}

	@Override
	public List<Long> getDistrictIds(List<DeliveryType> types) {
		List<Long> ids = Lists.newArrayList();
		if(CollectionUtils.isNotEmpty(types)){
			DeliveryDistrictEntityExample example = new DeliveryDistrictEntityExample();
			Criteria criteria = example.createCriteria();
			List<Short> typeIds = Lists.newArrayList();
			for (DeliveryType type : types) {
				typeIds.add(type.getId().shortValue());
			}
			criteria.andFlowerDevTypeIn(typeIds);
			criteria.andPcsTypeEqualTo(Byte.valueOf("3"));// TODO:pcsType为3表示取区信息
			List<DeliveryDistrictEntity> entities = this.mapper.selectByExample(example);
			for (DeliveryDistrictEntity entity : entities) {
				ids.add(entity.getOeId());// TODO:目前先用oeId, 以后这张表要改的吧
			}
		}
		return ids;
	}
}
