package com.thebeastshop.pegasus.component.compatible.service;

import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.product.enums.ProductSortField;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.page.Page;

/**
 * 老系统中， 商品list信息是存在在官网项目中，此类就是为了从官网端获取商品list
 * 
 * @author Paul-xiong
 *
 */
public interface ListService {

	/**
	 * 查询商品list 增加库存判断
	 * 
	 * @param id
	 * @param offset
	 * @param limit
	 * @param sortField
	 * @param sortOrder
	 * @param channelCode
	 * @return
	 */
	Page<PsProductVO> findById(long id, int offset, int limit, ProductSortField sortField, String sortOrder,
			String channelCode, MemberVO member, AccessWay accessWay);

}
