package com.thebeastshop.pegasus.component.compatible.service;

import java.util.List;

import com.thebeastshop.pegasus.component.compatible.ResourceWithCode;

/**
 * 老系统中，有一些资源是有code字段的。该字段也可以作为唯一标识，但同时也有id字段。
 * 一些关联表、关联字段关联的是code，一些关联的是id，这不好。在系统内部，有id就够了。code是跟展示耦合而不应该跟存储和计算耦合。
 * 但目前还没空去处理id和code之争。本接口就是用来专门从老系统中进行id和code转换的。
 *
 * @author Liang Wenjian
 */
public interface IDCodeTransferService {

	String getCode(ResourceWithCode resourceWithCode, long id);
	
	List<String> getCodes(ResourceWithCode resourceWithCode, List<Long> ids);
	
	Long getId(ResourceWithCode resourceWithCode, String code);
	
	List<Long> getIds(ResourceWithCode resourceWithCode, List<String> codes);
}
