package com.thebeastshop.pegasus.component.category.support;

import com.thebeastshop.pegasus.component.category.CategoryFront;
import com.thebeastshop.pegasus.component.category.model.CategoryFrontEntity;

/**
 * @author Liang Wenjian
 */
public class OldModelAdaptorCategoryFront extends CategoryFrontTemplate {

	private static final Integer IN_USE = 1;
	private static final Integer NOT_IN_USE = 0;// 是0吧？？？

	public static boolean inUseToValid(final CategoryFrontEntity oldModel) {
		return IN_USE.equals(oldModel.getInUse());
	}

	public static int validToInUse(final CategoryFront category) {
		return category.isValid() ? IN_USE : NOT_IN_USE;
	}

	private CategoryFrontEntity oldModel;

	public OldModelAdaptorCategoryFront(final CategoryFrontEntity entity) {
		super();
		this.oldModel = entity;
	}

	@Override
	public String getNote() {
		return "";
	}

	@Override
	public String getFullName() {
		return oldModel.getFullName();
	}

	@Override
	public Long getParentId() {
		return oldModel.getParentId();
	}

	@Override
	public Long getId() {
		return oldModel.getId();
	}

	@Override
	public String getName() {
		return oldModel.getName();
	}

	@Override
	public boolean isValid() {
		return inUseToValid(oldModel);
	}

	@Override
	public String getCode() {
		// TODO Auto-generated method stub
		return oldModel.getCode();
	}
}
