package com.thebeastshop.pegasus.component.category.support;

import com.thebeastshop.pegasus.component.category.Category;
import com.thebeastshop.pegasus.component.category.CategoryFront;

import java.util.Objects;

/**
 * @author Liang Wenjian
 */
public abstract class CategoryFrontTemplate implements CategoryFront {

    public CategoryFrontTemplate() {
        super();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Category)) {
            return false;
        }
        final Category that = (Category) o;
        return Objects.equals(getId(), that.getId());
    }



    @Override
    public String toString() {
        return getClass().getSimpleName() + hashCode() + ":{" +
                "id:" + getId() +
                ", name:'" + getName() + '\'' +
                ", parentId:" + getParentId() +
                ", valid:" + isValid() +
                ", note:'" + getNote() + '\'' +
                '}';
    }
}
