package com.thebeastshop.pegasus.component.category.dao;

import java.util.Collection;
import java.util.List;

import com.thebeastshop.pegasus.component.category.CampaignCategory;
import com.thebeastshop.pegasus.component.category.Category;

/**
 * 类目
 * 
 * @author Paul-xiong
 *
 */
public interface CategoryDao {

	/**
	 * 创建一个分类。
	 *
	 * @param one
	 *            分类
	 * @return 创建后的分类。
	 */
	Category create(final Category one);

	/**
	 * 修改
	 *
	 * @param one
	 */
	void modify(Category one);

	/**
	 * 删除
	 * 
	 * @param category
	 */
	void del(Category category);

	/**
	 * 获取某分类的直接子分类。
	 *
	 * @return 子分类列表。
	 */
	Collection<Category> directChildren(final Category one);

	/**
	 * 获取所有后代
	 *
	 * @param one
	 *            分类
	 * @return 所有后代
	 */
	Collection<Category> subordinates(final Category one);

	/**
	 * 根据id获取分类
	 * 
	 * @param id
	 * @return
	 */
	Category getById(final Long id);

	/**
	 * 获取分类列表。
	 *
	 * @return
	 */
	Collection<Category> list();

	/**
	 * 活动指定活动id所涉及的类目信息
	 *
	 * @param campaignId   活动编号
	 * @param temp 是否临时记录
	 * @return
	 */
	List<CampaignCategory> getCategoryByCampaignId(Long campaignId, Boolean temp);

	/**
	 * 获取所有的类目信息树
	 *
	 * @return
	 */
	List<CampaignCategory> getAllCategories();

	/**
	 * 通过目录查找该目录所对应的所有最低级子目录
	 *
	 * @param categories	要查找目录集合
	 *
	 * @return
	 */
	List<Long> getTreeNode(List<Long> categories);

	/**
	 * 根据id获取类目编码
	 *
	 * @param bindingId
	 *
	 * @return
	 */
	String getCodeById(Long bindingId);

	/**
	 * 获取指定活动中勾选的类目编号集合
	 * @param campaignId
	 * @return
	 */
	List<Long> getCategoryIdsByCampaignId(Long campaignId, Boolean temp);
}
