package com.thebeastshop.pegasus.component.category;

import org.springframework.beans.factory.annotation.Autowired;

import com.thebeastshop.pegasus.component.category.service.CategoryService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;

/**
 * 收藏服务外观器
 * 
 * @author Paul-xiong
 *
 */
public class PegasusCategoryServiceFacade {

	private static PegasusCategoryServiceFacade instance;

	@Autowired
	private CategoryService categoryService;

	public static PegasusCategoryServiceFacade getInstance() {
		if (instance != null) {
			return instance;
		}

		synchronized (PegasusFacadeLock.class) {
			if (instance == null) {
				instance = ComponentServiceLoader.getBean(PegasusCategoryServiceFacade.class);
			}
		}
		return instance;
	}

	/**
	 * 带检查地获取一个分类
	 * 
	 * @param id
	 * @return
	 */
	public Category checkOne(final Long id) {
		return this.categoryService.checkOne(id);
	}

}
