package com.thebeastshop.pegasus.component.campaign;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

/**
 * 活动针对的商品范围。共有3种：但商品活动、多商品活动、全场活动。
 *
 * @author Liang Wenjian
 */
public enum ProductScope implements HasIntIdGetter, HasName {
    /**
     * 单商品活动
     */
    SINGLE(1, "单商品活动"),
    /**
     * 多商品活动
     */
    MULTI(2, "多商品活动"),
    /**
     * 全场活动
     */
    GLOBAL(3, "全场活动");

    private final Integer id;
    private final String name;


    ProductScope(final Integer id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
