package com.thebeastshop.pegasus.component.campaign;

/**
 * 阶梯规则枚举
 * Created by GFL on 2017/6/6.
 */
public enum LadderRuleEnum {

    ALL_LADDER(1, "所有满足条件阶梯"),
    MAX_LADDER(2, "满足最高难度条件阶梯");

    private Integer code;
    private String desc;

    LadderRuleEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 更加Code获取阶梯规则
     *
     * @param code
     * @return
     */
    public static LadderRuleEnum getLadderRuleByCode(Integer code) {
        for (LadderRuleEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return ALL_LADDER;
    }
}
