package com.thebeastshop.pegasus.component.campaign;

import com.thebeastshop.support.mark.State;

/**
 * 活动上下线状态枚举类
 *
 * @author hafiz.zhang
 */
public enum CampaignState implements State {

    ENDED(-3, "已结束"),
    WILL_START(-2, "即将开始"),
    ON_GOING(-1, "进行中"),
    WAIT_FOR_ONLINE(0, "待上线"),
    ONLINE(1, "上线"),
    OFFLINE(2, "下线");

    private final Integer id;
    private final String name;

    CampaignState(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
