package com.thebeastshop.pegasus.component.campaign;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionImpl;
import com.thebeastshop.support.mark.HasIdGetter.HasLongIdGetter;
import com.thebeastshop.support.mark.HasRanking;

/**
 * 活动门槛区间。
 * 一个活动可能有多个门槛区间，比如【满100减10，满200减30】就是两个区间。不同区间之间的价格影响因子、额外商品可能是不同的，也不一定是线性的。
 *
 * @author Liang Wenjian
 */
@JsonDeserialize(as = DefaultCampaignSectionImpl.class)
public interface CampaignSection extends HasLongIdGetter, HasRanking {

	/**
	 * 活动id
	 * 
	 * @return
	 */
	Long getCampaignId();

	/**
	 * 参与活动的门槛类型。
	 *
	 * @return
	 */
	ConditionType getConditionType();

	/**
	 * 参与活动的门槛的值。超过此线就满足
	 *
	 * @return
	 */
	BigDecimal getLine();

	/**
	 * 获取价格影响因子类型
	 *
	 * @return
	 */
	FactorTypeEnum getFactorType();

	/**
	 * 影响因子。是+是*是-取决于活动类型。
	 *
	 * @return
	 */
	BigDecimal getFactor();

	/**
	 * 获取是否为临时记录
	 *
	 * @return
	 */
	Integer getTemp();

	@Override
	double getRanking();

	/**
	 * 额外商品配置
	 *
	 * @return
	 */
	List<CampaignSectionProduct> getCampaignSectionProducts();

	Comparator<CampaignSection> DESC = new Comparator<CampaignSection>() {
		@Override
		public int compare(CampaignSection o1, CampaignSection o2) {
			if (o2.getLine() == null) {
				return -1;
			}
			return o1.getLine().compareTo(o2.getLine());
		};
	};
}
