package com.thebeastshop.pegasus.component.adaptor.tracking.service.impl;

import com.thebeastshop.pegasus.component.adaptor.tracking.TrackingData;
import com.thebeastshop.pegasus.component.adaptor.tracking.dao.mapper.TrackingDataEntityMapper;
import com.thebeastshop.pegasus.component.adaptor.tracking.model.TrackingDataEntity;
import com.thebeastshop.pegasus.component.adaptor.tracking.service.TrackingDataService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * Created by Administrator on 2016/11/4.
 */
@Service
public class TrackingDataServiceImpl implements TrackingDataService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private TrackingDataEntityMapper trackingDataEntityMapper;

    @Override
    public boolean addTrackingData(TrackingData trackingData) {
        if(trackingData==null){
            logger.warn("添加Tracking回调信息：TrackingData is null");
        }else{
            logger.debug("addTrackingData 入参："+trackingData.toString());
            TrackingDataEntity entity = BeanUtil.buildFrom(trackingData,TrackingDataEntity.class);
            trackingDataEntityMapper.insertSelective(entity);
        }
        return true;
    }
}
