package com.thebeastshop.pegasus.component.adaptor.tracking.service.impl;

import com.thebeastshop.pegasus.component.adaptor.tracking.TouTiaoData;
import com.thebeastshop.pegasus.component.adaptor.tracking.dao.mapper.TouTiaoFeedbackDataMapper;
import com.thebeastshop.pegasus.component.adaptor.tracking.model.TouTiaoFeedbackData;
import com.thebeastshop.pegasus.component.adaptor.tracking.model.TouTiaoFeedbackDataExample;
import com.thebeastshop.pegasus.component.adaptor.tracking.service.TouTiaoFeedbackService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by feilong.gao on 2017/3/9.
 */
@Service
public class TouTiaoFeedBackServiceImpl implements TouTiaoFeedbackService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private TouTiaoFeedbackDataMapper mapper;

    @Override
    public boolean saveFeedbackData(TouTiaoData touTiaoData) {
        if (touTiaoData == null) {
            logger.warn("保存广点通点击信息：GdtClickData is null");
            return false;
        } else {
            logger.debug("saveClickData 入参：" + touTiaoData.toString());
            TouTiaoFeedbackData entity = BeanUtil.buildFrom(touTiaoData, TouTiaoFeedbackData.class);
            mapper.insertSelective(entity);
        }
        return true;
    }

    @Override
    public TouTiaoData queryMateDate(TouTiaoData touTiaoData) {

        if (touTiaoData == null) {
            logger.warn("入参对象：{}", touTiaoData);
            return null;
        }
        if (StringUtils.isEmpty(touTiaoData.getImei()) && StringUtils.isEmpty(touTiaoData.getIdfa())) {
            logger.warn("入参对象：{}", touTiaoData);
            return null;
        }

        TouTiaoFeedbackDataExample example = new TouTiaoFeedbackDataExample();
        TouTiaoFeedbackDataExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(touTiaoData.getIdfa())) {
            criteria.andIdfaEqualTo(touTiaoData.getIdfa());
        }
        if (StringUtils.isNotEmpty(touTiaoData.getImei())) {
            criteria.andImeiEqualTo(touTiaoData.getImei());
        }
        if (StringUtils.isNotEmpty(touTiaoData.getMac())) {
            criteria.andMacEqualTo(touTiaoData.getMac());
        }
        criteria.andCreateTimeGreaterThanOrEqualTo(DateUtil.addDay(new Date(),-7));

        example.setOrderByClause("id desc");
        List<TouTiaoFeedbackData> list = mapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            TouTiaoData entity = BeanUtil.buildFrom(list.get(0), TouTiaoData.class);
            return entity;
        }
        return null;
    }

}
