package com.thebeastshop.pegasus.component.adaptor.tracking.service.impl;

import com.thebeastshop.pegasus.component.adaptor.luhan.model.LuhanOrderExample;
import com.thebeastshop.pegasus.component.adaptor.tracking.GdtClickData;
import com.thebeastshop.pegasus.component.adaptor.tracking.dao.mapper.GdtClickDataEntityMapper;
import com.thebeastshop.pegasus.component.adaptor.tracking.model.GdtClickDataEntity;
import com.thebeastshop.pegasus.component.adaptor.tracking.model.GdtClickDataEntityExample;
import com.thebeastshop.pegasus.component.adaptor.tracking.service.GdtClickDataService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by feilong.gao on 2016/12/19.
 */
@Service
public class GdtClickDataServiceImpl implements GdtClickDataService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private GdtClickDataEntityMapper gdtClickDataEntityMapper;

    @Override
    public boolean saveClickData(GdtClickData gdtClickData) {
        if (gdtClickData == null) {
            logger.warn("保存广点通点击信息：GdtClickData is null");
        } else {
            logger.debug("saveClickData 入参：" + gdtClickData.toString());
            GdtClickDataEntity entity = BeanUtil.buildFrom(gdtClickData, GdtClickDataEntity.class);
            gdtClickDataEntityMapper.insertSelective(entity);
        }
        return true;
    }


    @Override
    public GdtClickData queryByMuid(String muid) {
        if (muid == null) {
            logger.warn("查询根据muid[{}]查询广点通点击", muid);
        } else {
            GdtClickDataEntityExample example = new GdtClickDataEntityExample();
            GdtClickDataEntityExample.Criteria criteria = example.createCriteria();
            criteria.andMuidEqualTo(muid);
            criteria.andClickTimeGreaterThanOrEqualTo(DateUtil.addDay(new Date(),-7).getTime()/1000+"");
            example.setOrderByClause("id desc");
            List<GdtClickDataEntity> list = gdtClickDataEntityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(list)) {
                GdtClickData entity = BeanUtil.buildFrom(list.get(0), GdtClickData.class);
                return entity;
            }
        }
        return null;
    }
}
