package com.thebeastshop.pegasus.component.adaptor.sns.service.impl;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.adaptor.sns.config.WeiXinConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXAccessToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXJsAccessToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXJsConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXJsTicket;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiXinService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import com.thebeastshop.support.encode.Sha1Util;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;

@Service
public class WeiXinServiceImpl implements WeiXinService {

	private static final String CHARSET = "UTF-8";

	@Autowired
	private RedisService redisService;

	// ===============private=================
	private String buildJsAccessTokenKey(String appId) {
		return "js_access_token-" + appId;
	}

	private String buildJsTicketKey(String access_token) {
		return "js_ticket-" + access_token;
	}

	/**
	 * 获取js sdk accessToken
	 * 
	 * @param appId
	 * @param secret
	 * @return
	 * @throws Exception
	 */
	private WXJsAccessToken getJsAccessToken(String appId, String secret) throws Exception {
		// 获取access_token
		WXJsAccessToken accessToken = redisService.get(buildJsAccessTokenKey(appId), WXJsAccessToken.class);
		if (accessToken == null) {
			String url = WeiXinConfig.JS_SDK_ACCESS_TOKEN_URL;
			Map<String, String> params = Maps.newHashMap();
			params.put("grant_type", "client_credential");
			params.put("appid", appId);
			params.put("secret", secret);
			String dataStr = HttpUtil.doGet(url, params, CHARSET);
			accessToken = JsonUtil.toObject(dataStr, WXJsAccessToken.class);
			if (accessToken == null || StringUtils.isBlank(accessToken.getAccess_token())) {
				throw new NoSuchResourceException("获取微信jssdk access token失败!", "access token", dataStr);
			}
			// 缓存access_token, 有效时间减去60秒，避免碰到临界值的情况
			redisService.set(buildJsAccessTokenKey(appId), accessToken, accessToken.getExpires_in().intValue() - 60);
		}
		return accessToken;
	}

	/**
	 * 
	 * @param access_token
	 * @return
	 * @throws Exception
	 */
	private WXJsTicket getJsTicket(String access_token) throws Exception {
		// 获取access_token
		WXJsTicket ticket = redisService.get(buildJsTicketKey(access_token), WXJsTicket.class);
		if (ticket == null) {
			String url = WeiXinConfig.JS_SDK_TICKET_URL;
			Map<String, String> params = Maps.newHashMap();
			params.put("access_token", access_token);
			params.put("type", "jsapi");
			String dataStr = HttpUtil.doGet(url, params, CHARSET);
			ticket = JsonUtil.toObject(dataStr, WXJsTicket.class);
			if (ticket == null || !ticket.getErrcode().equals("0") || !ticket.getErrmsg().equals("ok")) {
				throw new NoSuchResourceException("获取微信jssdk ticket失败!", "ticket", dataStr);
			}
			// 缓存ticket, 有效时间减去60秒，避免碰到临界值的情况
			redisService.set(buildJsTicketKey(access_token), ticket, ticket.getExpires_in().intValue() - 60);
		}
		return ticket;
	}
	// =======================================

	@Override
	public WXAccessToken getAccessToken(String code) {
		WXAccessToken accessToken = null;

		// api接口
		StringBuilder url = new StringBuilder(WeiXinConfig.ACCESS_TOKEN_URL);
		// app id
		String appId = WeiXinConfig.APP_ID;
		// secret
		String secret = WeiXinConfig.SECRET;

		// 拼接请求参数
		url.append("?").append("appid=").append(appId).append("&secret=").append(secret).append("&code=").append(code)
				.append("&grant_type=authorization_code");

		try {
			// 调用请求
			String dataStr = HttpUtil.doGet(url.toString(), null, CHARSET);

			accessToken = JsonUtil.toObject(dataStr, WXAccessToken.class);
		} catch (Exception e) {
			throw new UnknownException(e.getMessage());
		}

		if (accessToken == null || StringUtils.isBlank(accessToken.getAccess_token())) {
			throw new WrongArgException("获取微信access_token失败");
		}
		return accessToken;
	}

	@Override
	public WXUserInfo getUserInfo(String accessToken, String openId) {
		WXUserInfo userInfo = null;

		// api接口
		StringBuilder url = new StringBuilder(WeiXinConfig.USER_INFO_URL);

		// 拼接请求参数
		url.append("?").append("access_token=").append(accessToken).append("&openid=").append(openId);

		try {
			// 调用请求
			String dataStr = HttpUtil.doGet(url.toString(), null, CHARSET);
			userInfo = JsonUtil.toObject(dataStr, WXUserInfo.class);
		} catch (Exception e) {
			throw new UnknownException(e.getMessage());
		}

		if (userInfo == null || StringUtils.isBlank(userInfo.getUnionid())) {
			throw new WrongArgException("获取微信用户信息失败");
		}
		return userInfo;
	}

	@Override
	public WXJsConfig getJsConfig(String url,String accessToken) {
		try {
			String appId = WeiXinConfig.APP_ID2;
			//String secret = WeiXinConfig.SECRET2;
			Long timestamp = System.currentTimeMillis() / 1000;
			String noncestr = StringUtil.getRandomString(16);
			// 签名
			//WXJsAccessToken accessToken = getJsAccessToken(appId, secret);
			WXJsTicket ticket = getJsTicket(accessToken);
			Map<String, Object> params = Maps.newHashMap();
			params.put("noncestr", noncestr);
			params.put("jsapi_ticket", ticket.getTicket());
			params.put("timestamp", timestamp);
			params.put("url", url);
			String signature = Sha1Util.sha1ToHexString(params);
			return new WXJsConfig(appId, timestamp, noncestr, signature);
		} catch (Exception e) {
			throw new UnknownException(e);
		}
	}
	
//	@Override
//	public String takeToken(){
//		String appId = WeiXinConfig.APP_ID2;
//		String secret = WeiXinConfig.SECRET2;
//		// 签名
//		WXJsAccessToken accessToken;
//		try {
//			accessToken = getJsAccessToken(appId, secret);
//			return accessToken.getAccess_token();
//		} catch (Exception e) {
//			
//			e.printStackTrace();
//		}
//		
//		return "";
//	}

	public static void main(String[] args) {
		//WeiXinService service = ComponentServiceLoader.getBean(WeiXinService.class);
		//System.out.println(service.getJsConfig("http://mp.weixin.qq.com?params=value"));
	}
}
