package com.thebeastshop.pegasus.component.adaptor.sns.service.impl;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.component.adaptor.sns.config.WeiBoConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WBUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiBoService;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;

@Service
public class WeiBoServiceImpl implements WeiBoService {

	private static final String CHARSET = "UTF-8";

	@Override
	public WBUserInfo getUserInfo(String accessToken, String uid) {
		WBUserInfo userInfo = null;

		// api接口
		StringBuilder url = new StringBuilder(WeiBoConfig.getShowUrl());

		// 拼接请求参数
		url.append("?").append("access_token=").append(accessToken).append("&uid=").append(uid);

		try {
			// 调用请求
			String dataStr = HttpUtil.doGet(url.toString(), null, CHARSET);
			userInfo = JsonUtil.toObject(dataStr, WBUserInfo.class);
		} catch (Exception e) {
			throw new UnknownException(e);
		}

		if (userInfo == null || StringUtils.isBlank(userInfo.getId())) {
			throw new WrongArgException("获取微博用户信息失败");
		}
		return userInfo;
	}

	// test
	public static void main(String[] args) {
		WeiBoService service = new WeiBoServiceImpl();
		String accessToken = "2.00cB3KyBPOFRlB3a85cc01a2ZTAdfB";
		String uid = "1805180940";
		System.out.println(service.getUserInfo(accessToken, uid));
	}

}
