package com.thebeastshop.pegasus.component.adaptor.sns.service.impl;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Security;
import java.util.Arrays;
import java.util.Map;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.adaptor.sns.config.WeChatAppletConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXJsAccessToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WeChatAppletToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WeChatAppletUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeChatAppletService;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiXinService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;

@Service
public class WeChatAppletServiceImpl implements WeChatAppletService {

	private static final String CHARSET = "UTF-8";

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private RedisService redisService;

	@Autowired
	private WeiXinService weixinService;

	// app id
	String appId = WeChatAppletConfig.APP_ID;
	// app secret
	String appSecret = WeChatAppletConfig.SECRET;

	private String buildSessionKey(String appId) {
		return "weChatApplet_sessionKey-" + appId;
	}

	// 算法名
	public static final String KEY_ALGORITHM = "AES";

	/**
	 * 获取SessionKey
	 * 
	 * @param appId
	 * @param secret
	 * @param code
	 * @return
	 * @throws Exception
	 */
	private WeChatAppletToken getSession_key(String code) throws Exception {
		String url = WeChatAppletConfig.SESSION_KEY_URL;

		// 获取access_token
		// WeChatAppletToken sessionKey =
		// redisService.get(buildSessionKey(appId), WeChatAppletToken.class);
		// if (null == sessionKey) {

		Map<String, String> params = Maps.newHashMap();
		params.put("appid", appId);
		params.put("secret", appSecret);
		params.put("js_code", code);
		params.put("grant_type", "client_credential");
		String dataStr = "";
		dataStr = HttpUtil.doGet(url, params, CHARSET);
		WeChatAppletToken sessionKey = JsonUtil.toObject(dataStr, WeChatAppletToken.class);
		if (sessionKey == null || StringUtils.isBlank(sessionKey.getSession_key())) {
			throw new NoSuchResourceException("获取微信小程序session_key失败!", "session_key", dataStr);
			// }
			// 缓存access_token, 有效时间减去60秒，避免碰到临界值的情况
			// redisService.set(buildSessionKey(appId), sessionKey,
			// sessionKey.getExpires_in().intValue() / 1000 - 60);
		}
		return sessionKey;
	}

	/**
	 * 签名校验
	 * 
	 * @param rawData
	 * @param session_key
	 * @param signature
	 * @return
	 * @throws Exception
	 */
	private boolean signatureValidation(String sessionKey, String rawData, String signature) throws Exception {
		Boolean status = false;

		StringBuffer sb = new StringBuffer(rawData);
		sb.append(sessionKey);
		String encryData = DigestUtils.sha1Hex(sb.toString());
		if (encryData.equals(signature)) {
			status = true;
		} else {
			throw new NoSuchResourceException("签名校验失败！", "signature", signature);
		}

		return status;
	}

	/**
	 * 用户信息解密
	 * 
	 * @param encryptedData
	 * @param iv
	 * @return
	 * @throws Exception
	 */
	private WeChatAppletUserInfo decodeEncryptedData(String encryptedData, String iv, String sessionKey) throws Exception {
		WeChatAppletUserInfo wxInfo = new WeChatAppletUserInfo();

		String json = wxDecrypt(encryptedData, sessionKey, iv);
		System.out.println(json);

		wxInfo = JsonUtil.toObject(json, WeChatAppletUserInfo.class);
		if (wxInfo != null) {
			logger.debug("获取微信用户unionId{}" + wxInfo.getUnionId());
		} else {
			throw new NoSuchResourceException("用户信息解密失败!", "unionId", wxInfo);
		}
		return wxInfo;
	}

	@Override
	public WeChatAppletUserInfo getUserInfo(String rawData, String encryptedData, String iv, String signature, String code) {
		WeChatAppletUserInfo userInfo = new WeChatAppletUserInfo();
		try {
			// 获取session_key
			WeChatAppletToken token = getSession_key(code);

			// String session = "CxVNzTTkqzOU2AhqoajHhg==";
			// boolean status = signatureValidation(session, rawData,
			// signature);
			String avatarUrl = "";
			if(StringUtils.isNotBlank(rawData)){
				JSONObject jsonData = JSONObject.parseObject(rawData);
				avatarUrl = jsonData.getString("avatarUrl");
			}

			boolean status = signatureValidation(token.getSession_key(), rawData, signature);
			if (status) {
				userInfo = decodeEncryptedData(encryptedData, iv, token.getSession_key());
				userInfo.setAvatarUrl(avatarUrl);
				// userInfo = decodeEncryptedData(encryptedData, iv, session);
			}
		} catch (Exception e) {
			throw new UnknownException(e);
		}

		return userInfo;
	}

	// 算法名
	public static final String KEY_NAME = "AES";
	// 加解密算法/模式/填充方式
	// ECB模式只用密钥即可对数据进行加密解密，CBC模式需要添加一个iv
	public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS7Padding";

	/**
	 * 微信 数据解密<br/>
	 * 对称解密使用的算法为 AES-128-CBC，数据采用PKCS#7填充<br/>
	 * 对称解密的目标密文:encrypted=Base64_Decode(encryptData)<br/>
	 * 对称解密秘钥:key = Base64_Decode(session_key),aeskey是16字节<br/>
	 * 对称解密算法初始向量:iv = Base64_Decode(iv),同样是16字节<br/>
	 *
	 * @param encrypted
	 *            目标密文
	 * @param session_key
	 *            会话ID
	 * @param iv
	 *            加密算法的初始向量
	 */
	public static String wxDecrypt(String encrypted, String session_key, String iv) {
		String json = null;
		byte[] encrypted64 = Base64.decodeBase64(encrypted);
		byte[] key64 = Base64.decodeBase64(session_key);
		byte[] iv64 = Base64.decodeBase64(iv);
		// byte[] data;
		try {
			init();
			json = new String(decrypt(encrypted64, key64, generateIV(iv64)));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return json;
	}

	/**
	 * 初始化密钥
	 */
	public static void init() throws Exception {
		Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
		KeyGenerator.getInstance(KEY_NAME).init(128);
	}

	/**
	 * 生成iv
	 */
	public static AlgorithmParameters generateIV(byte[] iv) throws Exception {
		// iv 为一个 16 字节的数组，这里采用和 iOS 端一样的构造方法，数据全为0
		// Arrays.fill(iv, (byte) 0x00);
		AlgorithmParameters params = AlgorithmParameters.getInstance(KEY_NAME);
		params.init(new IvParameterSpec(iv));
		return params;
	}

	/**
	 * 生成解密
	 */
	public static byte[] decrypt(byte[] encryptedData, byte[] keyBytes, AlgorithmParameters iv) throws Exception {
		// 如果密钥不足16位，填充
		int base = 16;
		if (keyBytes.length % base != 0) {
			int groups = keyBytes.length / base + (keyBytes.length % base != 0 ? 1 : 0);
			byte[] temp = new byte[groups * base];
			Arrays.fill(temp, (byte) 0);
			System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
			keyBytes = temp;
		}
		Key key = new SecretKeySpec(keyBytes, KEY_NAME);
		Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
		// 设置为解密模式
		cipher.init(Cipher.DECRYPT_MODE, key, iv);
		return cipher.doFinal(encryptedData);
	}

}
