package com.thebeastshop.pegasus.component.adaptor.sns.config;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.config.PropertyConfigurer;

/**
 * QQ配置信息
 * 
 * @author Paul-xiong
 *
 */
public class QQConfig {

	/**
	 * 获取用户信息接口
	 */
	private static String simpleUserInfo_url = "https://graph.qq.com/user/get_simple_userinfo";

	/**
	 * appid for ios
	 */
	private static String appIdForIOS = "1105352890";

	/**
	 * appid for android
	 */
	private static String appIdForAndroid = "1105279871";

	public static String getSimpleUserInfoUrl() {
		return simpleUserInfo_url;
	}

	public static String getAppIdForIOS() {
		return appIdForIOS;
	}

	public static String getAppIdForAndroid() {
		return appIdForAndroid;
	}

	static {
		PropertyConfigurer configurer = ComponentServiceLoader.getBean(PropertyConfigurer.class);
		if (configurer != null) {
			String appIdIos = configurer.getProperty("qq.appIdForIOS");
			if (StringUtils.isNotBlank(appIdIos)) {
				appIdForIOS = appIdIos;
			}
			String appIdAndroid = configurer.getProperty("qq.appIdForAndroid");
			if (StringUtils.isNotBlank(appIdAndroid)) {
				appIdForAndroid = appIdAndroid;
			}
		}
	}

}
