package com.thebeastshop.pegasus.component.adaptor.sns;

import org.springframework.beans.factory.annotation.Autowired;

import com.thebeastshop.pegasus.component.adaptor.sns.domain.QQUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WBUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXAccessToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WeChatAppletUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.QQService;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeChatAppletService;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiBoService;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiXinService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;

/**
 * 社交平台组件外观者
 * 
 * @author Paul-xiong
 *
 */
public class PegasusSnsServiceFacade {

	private static PegasusSnsServiceFacade instance;

	@Autowired
	private QQService qqService;

	@Autowired
	private WeiXinService weixinService;

	@Autowired
	private WeiBoService weiboService;

	@Autowired
	private WeChatAppletService weChatAppletService;

	public static PegasusSnsServiceFacade getInstance() {
		if (instance != null) {
			return instance;
		}

		synchronized (PegasusFacadeLock.class) {
			if (instance == null) {
				instance = ComponentServiceLoader.getBean(PegasusSnsServiceFacade.class);
			}
		}
		return instance;
	}

	/**
	 * 获取简单的用户信息
	 * 
	 * @param accessToken
	 *            访问qq接口的授权认证
	 * @param openId
	 *            qq用户的标识
	 * @param platform
	 *            平台（ios或者android平台获取qq用户信息）
	 * @return
	 */
	public QQUserInfo getQQSimpleUserInfo(String accessToken, String openId, String platform) {
		return qqService.getSimpleUserInfo(accessToken, openId, platform);
	}

	/**
	 * 获取微信用户个人信息
	 * 
	 * @param code
	 *            获取access_token的code
	 * @return
	 */
	public WXUserInfo getWeiXinUserInfo(String code) {
		WXAccessToken accessToken = weixinService.getAccessToken(code);
		return weixinService.getUserInfo(accessToken.getAccess_token(), accessToken.getOpenid());
	}

	/**
	 * 获取微博用户个人信息
	 * 
	 * @param accessToken
	 *            访问接口的授权认证
	 * @return
	 */
	public WBUserInfo getWeiBoUserInfo(String accessToken, String uid) {
		return weiboService.getUserInfo(accessToken, uid);
	}

	/**
	 * 获取微信小程序用户信息
	 * 
	 * @param code
	 *            获取access_token的code
	 * @return
	 */
	public WeChatAppletUserInfo getWeChatUserInfo(String rawData, String encryptedData, String iv, String signature, String code) {
		return weChatAppletService.getUserInfo(rawData, encryptedData, iv, signature, code);
	}

}
