package com.thebeastshop.pegasus.component.adaptor.payment.service;

import java.util.Map;

import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXOrderQueryParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXOrderQueryResponse;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXUnifiedOrderParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXUnifiedOrderResponse;

/**
 * 微信第三方服务
 * 
 * @author Paul-xiong
 *
 */
public interface WeiXinPayService {

	/**
	 * 统一下单
	 * 
	 * @param params
	 *            微信统一下单参数
	 * @return
	 */
	public WXUnifiedOrderResponse unifiedOrder(WXUnifiedOrderParams params);

	/**
	 * 查询订单
	 * 
	 * @param params
	 *            查询订单参数
	 * @return
	 */
	public WXOrderQueryResponse orderQuery(WXOrderQueryParams params);

	/**
	 * 签名
	 * 
	 * @param map
	 *            签名map
	 * @return
	 */
	public String sign(Map<String, String> map);

	/**
	 * 签名
	 * 
	 * @param obj
	 *            签名对象
	 * @return
	 */
	public String sign(Object obj);


	/**
	 * 微信 pc的签名
	 * @param obj
	 * @return
	 */
	public String signPc(Object obj);
	/**
	 * 统一下单
	 * 
	 * @param params
	 *            微信小程序统一下单参数
	 * @return
	 */
	public WXUnifiedOrderResponse weChatAppletUnifiedOrder(WXUnifiedOrderParams params);

	/**
	 * 统一下单
	 *
	 * @param params
	 *            M站微信统一下单参数
	 * @return
	 */
	public WXUnifiedOrderResponse weChatAppletUnifiedOrder(WXUnifiedOrderParams params,Boolean isWebSite);

	/**
	 * 签名
	 * 
	 * @param map
	 *            签名map
	 * @return
	 */
	public String signForWX(Map<String, String> map);

	/**
	 * 签名
	 * 
	 * @param obj
	 *            签名对象
	 * @return
	 */
	public String signForWX(Object obj);

}
