package com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * 微信统一下单api请求(调用微信api时使用)
 * 
 * @author Paul-xiong
 *
 */
@XmlRootElement
public class WXUnifiedOrderRequest extends WXRequest{
	/**
	 * 商品或支付单简要描述 (示例:Ipad mini  16G  白色)
	 * 是否必填(是)
	 */
	private String body;
	/**
	 * 商品名称明细列表 (示例:Ipad mini  16G  白色)
	 * 是否必填(否)
	 */
	private String detail;
	/**
	 * 附加数据，在查询API和支付通知中原样返回，该字段主要用于商户携带订单的自定义数据 (示例:深圳分店)
	 * 是否必填(否)
	 */
	private String attach;
	/**
	 * 商户系统内部的订单号,32个字符内、可包含字母 (示例:20150806125346)
	 * 是否必填(是)
	 */
	private String out_trade_no;
	/**
	 * 符合ISO 4217标准的三位字母代码，默认人民币：CNY,说明详见微信统一下单文档 (示例:CNY)
	 * 是否必填(否)
	 */
	private String fee_type;
	/**
	 * 订单总金额，单位为分,说明详见微信统一下单文档 (示例:888)
	 * 是否必填(是)
	 */
	private String total_fee;
	/**
	 * 用户端实际ip (示例:123.12.12.123)
	 * 是否必填(是)
	 */
	private String spbill_create_ip;
	/**
	 * 订单生成时间，格式为yyyyMMddHHmmss,说明详见微信统一下单文档 (示例:20091225091010)
	 * 是否必填(否)
	 */
	private String time_start;
	/**
	 * 订单失效时间，格式为yyyyMMddHHmmss,注意：最短失效时间间隔必须大于5分钟,说明详见微信统一下单文档 (示例:20091225091010)
	 * 是否必填(否)
	 */
	private String time_expire;
	/**
	 * 商品标记，代金券或立减优惠功能的参数,说明详见微信统一下单文档 (示例:WXG)
	 * 是否必填(否)
	 */
	private String goods_tag;
	/**
	 * 接收微信支付异步通知回调地址，通知url必须为直接可访问的url，不能携带参数 (示例:http://www.weixin.qq.com/wxpay/pay.php)
	 * 是否必填(是)
	 */
	private String notify_url;
	/**
	 * 支付类型，取值如下：JSAPI，NATIVE，APP (示例:APP)
	 * 是否必填(是)
	 */
	private String trade_type;
	/**
	 * 指定支付方式,no_credit--指定不能使用信用卡支付 (示例:no_credit)
	 * 是否必填(否)
	 */
	private String limit_pay;
	/**
	 * trade_type=NATIVE，此参数必传。此id为二维码中包含的商品ID，商户自行定义 (示例:12235413214070356458058)
	 * 是否必填(否)
	 */
	private String product_id;
	/**
	 * trade_type=JSAPI，此参数必传，用户在商户appid下的唯一标识 (示例:oUpF8uMuAJO_M2pxb1Q9zNjWeS6o)
	 * 是否必填(否)
	 */
	private String openid;

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	public String getAttach() {
		return attach;
	}

	public void setAttach(String attach) {
		this.attach = attach;
	}

	public String getOut_trade_no() {
		return out_trade_no;
	}

	public void setOut_trade_no(String out_trade_no) {
		this.out_trade_no = out_trade_no;
	}

	public String getFee_type() {
		return fee_type;
	}

	public void setFee_type(String fee_type) {
		this.fee_type = fee_type;
	}

	public String getTotal_fee() {
		return total_fee;
	}

	public void setTotal_fee(String total_fee) {
		this.total_fee = total_fee;
	}

	public String getSpbill_create_ip() {
		return spbill_create_ip;
	}

	public void setSpbill_create_ip(String spbill_create_ip) {
		this.spbill_create_ip = spbill_create_ip;
	}

	public String getTime_start() {
		return time_start;
	}

	public void setTime_start(String time_start) {
		this.time_start = time_start;
	}

	public String getTime_expire() {
		return time_expire;
	}

	public void setTime_expire(String time_expire) {
		this.time_expire = time_expire;
	}

	public String getGoods_tag() {
		return goods_tag;
	}

	public void setGoods_tag(String goods_tag) {
		this.goods_tag = goods_tag;
	}

	public String getNotify_url() {
		return notify_url;
	}

	public void setNotify_url(String notify_url) {
		this.notify_url = notify_url;
	}

	public String getTrade_type() {
		return trade_type;
	}

	public void setTrade_type(String trade_type) {
		this.trade_type = trade_type;
	}

	public String getLimit_pay() {
		return limit_pay;
	}

	public void setLimit_pay(String limit_pay) {
		this.limit_pay = limit_pay;
	}
	
	public String getProduct_id() {
		return product_id;
	}

	public void setProduct_id(String product_id) {
		this.product_id = product_id;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	@Override
	public String toString() {
		return "WXUnifiedOrderRequest [body=" + body + ", detail=" + detail + ", attach=" + attach + ", out_trade_no="
				+ out_trade_no + ", fee_type=" + fee_type + ", total_fee=" + total_fee + ", spbill_create_ip="
				+ spbill_create_ip + ", time_start=" + time_start + ", time_expire=" + time_expire + ", goods_tag="
				+ goods_tag + ", notify_url=" + notify_url + ", trade_type=" + trade_type + ", limit_pay=" + limit_pay
				+ ", product_id=" + product_id + ", openid=" + openid + ", toString()=" + super.toString() + "]";
	}

}
