package com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin;

/**
 * 微信api请求基本参数(调用微信api时使用)
 * 
 * @author Paul-xiong
 *
 */
public abstract class WXRequest {
	// 基本参数
	
	/**
	 * 微信开放平台审核通过的应用APPID (示例:wxd678efh567hg6787)
	 * 是否必填(是)
	 */
	private String appid;
	/**
	 * 微信支付分配的商户号 (示例:1230000109)
	 * 是否必填(是)
	 */
	private String mch_id;
	/**
	 * 终端设备号(门店号或收银设备ID)，默认请传"WEB" (示例:013467007045764)
	 * 是否必填(否)
	 */
	private String device_info;
	/**
	 * 随机字符串，不长于32位 (示例:5K8264ILTKCH16CQ2502SI8ZNMTM67VS)
	 * 是否必填(是)
	 */
	private String nonce_str;
	/**
	 * 签名 (示例:C380BEC2BFD727A4B6845133519F3AD6)
	 * 是否必填(是)
	 */
	private String sign;

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getMch_id() {
		return mch_id;
	}

	public void setMch_id(String mch_id) {
		this.mch_id = mch_id;
	}

	public String getDevice_info() {
		return device_info;
	}

	public void setDevice_info(String device_info) {
		this.device_info = device_info;
	}

	public String getNonce_str() {
		return nonce_str;
	}

	public void setNonce_str(String nonce_str) {
		this.nonce_str = nonce_str;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	@Override
	public String toString() {
		return "WXRequest [appid=" + appid + ", mch_id=" + mch_id + ", device_info=" + device_info + ", nonce_str="
				+ nonce_str + ", sign=" + sign + ", toString()=" + super.toString() + "]";
	}

}
