package com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * 微信查询订单api请求(调用微信api时使用)
 * 
 * @author Paul-xiong
 *
 */
@XmlRootElement
public class WXOrderQueryRequest extends WXRequest {
	/**
	 * 微信的订单号，优先使用 (示例:1009660380201506130728806387)
	 * 是否必填(字段transaction_id与out_trade_no二选一)
	 */
	private String transaction_id;
	/**
	 * 商户系统内部的订单号,32个字符内、可包含字母 (示例:20150806125346)
	 * 是否必填(字段transaction_id与out_trade_no二选一)
	 */
	private String out_trade_no;

	public String getTransaction_id() {
		return transaction_id;
	}

	public void setTransaction_id(String transaction_id) {
		this.transaction_id = transaction_id;
	}

	public String getOut_trade_no() {
		return out_trade_no;
	}

	public void setOut_trade_no(String out_trade_no) {
		this.out_trade_no = out_trade_no;
	}

	@Override
	public String toString() {
		return "WXOrderQueryRequest [transaction_id=" + transaction_id + ", out_trade_no=" + out_trade_no
				+ ", toString()=" + super.toString() + "]";
	}

}
