package com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api2;

/**
 * 支付宝App支付请求参数(调用支付宝api时使用)
 * 
 * @author Paul-xiong
 *
 */
public class AlipayAppPayRequest implements AlipayRequest_API2 {

	/**
	 * 支付宝分配给开发者的应用Id (示例:2014072300007148)
	 * 是否必填(是)
	 */
	private String app_id;
	/**
	 * 接口名称 (示例:alipay.trade.query)
	 * 是否必填(是)
	 */
	private String method;
	/**
	 * 仅支持JSON
	 * 是否必填(否)
	 */
	private String format = "JSON";
	/**
	 * HTTP/HTTPS开头字符串(示例:https://m.alipay.com/Gk8NF23)
	 * 是否必填(否)
	 */
	private String return_url;
	/**
	 * 请求使用的编码格式，如utf-8,gbk,gb2312等 (示例:utf-8)
	 * 是否必填(是)
	 */
	private String charset = "utf-8";
	/**
	 * 签名类型，目前仅支持RSA (示例:RSA)
	 * 是否必填(是)
	 */
	private String sign_type = "RSA";
	/**
	 * 请参见支付宝签名 (示例:lBBK%2F0w5LOajrMrji7DUgEqNjIhQbidR13GovA5r3TgIbNqv231yC1NksLdw%2Ba3JnfHXoXuet6XNNHtn7VE%2BeCoRO1O%2BR1KugLrQEZMtG5jmJI)
	 * 是否必填(是)
	 */
	private String sign;
	/**
	 * 发送请求的时间，格式"yyyy-MM-dd HH:mm:ss" (示例:2014-07-24 03:07:50)
	 * 是否必填(是)
	 */
	private String timestamp;
	/**
	 * 调用的接口版本，固定为：1.0 (示例:1.0)
	 * 是否必填(是)
	 */
	private String version = "1.0";
	/**
	 * 支付宝服务器主动通知商户服务器里指定的页面http/https路径。 (示例: https://api.xx.com/receive_notify.htm)
	 * 是否必填(否)
	 */
	private String notify_url;
	/** 
	* 业务请求接口的参数体，JSON格式，具体包含的内容参见各个接口的请求参数
	 */
	private String biz_content;

	@Override
	public String getApp_id() {
		return app_id;
	}

	@Override
	public String getMethod() {
		return method;
	}

	@Override
	public String getCharset() {
		return charset;
	}

	@Override
	public String getSign_type() {
		return sign_type;
	}

	@Override
	public String getSign() {
		return sign;
	}

	@Override
	public String getTimestamp() {
		return timestamp;
	}

	@Override
	public String getVersion() {
		return version;
	}

	@Override
	public String getBiz_content() {
		return biz_content;
	}

	public void setApp_id(String app_id) {
		this.app_id = app_id;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public void setCharset(String charset) {
		this.charset = charset;
	}

	public void setSign_type(String sign_type) {
		this.sign_type = sign_type;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public void setTimestamp(String timestamp) {
		this.timestamp = timestamp;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public void setBiz_content(String biz_content) {
		this.biz_content = biz_content;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getReturn_url() {
		return return_url;
	}

	public void setReturn_url(String return_url) {
		this.return_url = return_url;
	}

	public String getNotify_url() {
		return notify_url;
	}

	public void setNotify_url(String notify_url) {
		this.notify_url = notify_url;
	}

	@Override
	public String toString() {
		return "AlipayAppPayRequest [app_id=" + app_id + ", method=" + method + ", format=" + format + ", return_url="
				+ return_url + ", charset=" + charset + ", sign_type=" + sign_type + ", sign=" + sign + ", timestamp="
				+ timestamp + ", version=" + version + ", notify_url=" + notify_url + ", biz_content=" + biz_content
				+ "]";
	}
	
}
