package com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1;

/**
 * 支付宝api请求基本参数(调用支付宝api1时使用)
 * 
 * @author Paul-xiong
 *
 */
public abstract class AlipayRequest_API1 {
	// 基本参数
	/**
	 * 接口名称，固定值 (示例:mobile.securitypay.pay)
	 * 是否必填(是)
	 */
	private String service;
	/**
	 * 签约的支付宝账号对应的支付宝唯一用户号。以2088开头的16位纯数字组成 (示例:2088101568358171)
	 * 是否必填(是)
	 */
	private String partner;
	/**
	 * 商户网站使用的编码格式，固定为utf-8 (示例:utf-8)
	 * 是否必填(是)
	 */
	private String _input_charset = "utf-8";
	/**
	 * 签名类型，DSA、RSA、MD5三个值可选，必须大写 (示例:RSA)
	 * 是否必填(是)
	 */
	private String sign_type;
	/**
	 * 请参见支付宝签名 (示例:lBBK%2F0w5LOajrMrji7DUgEqNjIhQbidR13GovA5r3TgIbNqv231yC1NksLdw%2Ba3JnfHXoXuet6XNNHtn7VE%2BeCoRO1O%2BR1KugLrQEZMtG5jmJI)
	 * 是否必填(是)
	 */
	private String sign;
	/**
	 * 支付宝服务器主动通知商户网站里指定的页面http路径 (示例:http://notify.msp.hk/notify.htm)
	 * 是否必填(是)
	 */
	private String notify_url;
	/**
	 * 支付宝处理完请求后，当前页面自动跳转到商户网站里指定页面的http路径 (示例:http://api.test.alipay.net/atinterface/receive_return.htm)
	 * 是否必填(否)
	 */
	private String return_url;

	public String getService() {
		return service;
	}

	public void setService(String service) {
		this.service = service;
	}

	public String getPartner() {
		return partner;
	}

	public void setPartner(String partner) {
		this.partner = partner;
	}

	public String get_input_charset() {
		return _input_charset;
	}

	public void set_input_charset(String _input_charset) {
		this._input_charset = _input_charset;
	}

	public String getSign_type() {
		return sign_type;
	}

	public void setSign_type(String sign_type) {
		this.sign_type = sign_type;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getNotify_url() {
		return notify_url;
	}

	public void setNotify_url(String notify_url) {
		this.notify_url = notify_url;
	}

	public String getReturn_url() {
		return return_url;
	}

	public void setReturn_url(String return_url) {
		this.return_url = return_url;
	}

	@Override
	public String toString() {
		return "AlipayRequest_API1 [service=" + service + ", partner=" + partner + ", _input_charset=" + _input_charset
				+ ", sign_type=" + sign_type + ", sign=" + sign + ", notify_url=" + notify_url + ", return_url="
				+ return_url + "]";
	}

}
