package com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1;

/**
 * 支付宝即时到账请求参数(调用支付宝api时使用)
 * 
 * @author Paul-xiong
 *
 */
public class AlipayDirectPayRequest extends AlipayRequest_API1 {
	// 业务参数

	/**
	 * 支付宝合作商户网站唯一订单号 (示例:0819145412-6177)
	 * 是否必填(是)
	 */
	private String out_trade_no;
	/**
	 * 商品的标题/交易标题/订单标题/订单关键字等。该参数最长为128个汉字 (示例:测试)
	 * 是否必填(是)
	 */
	private String subject;
	/**
	 * 支付类型。默认值为：1（商品购买）(示例:1)
	 * 是否必填(是)
	 */
	private String payment_type = "1";
	/**
	 * 该笔订单的资金总额，单位为RMB-Yuan。取值范围为[0.01，100000000.00]，精确到小数点后两位 (示例:0.01)
	 * 是否必填(是)
	 */
	private String total_fee;
	/**
	 * 卖家支付宝用户号，是以2088开头的纯16位数字 (示例:2088002007018966)
	 * 是否必填(seller_id，seller_email，seller_account_name三个参数至少必须传递一个)
	 */
	private String seller_id;
	/**
	 * 卖家支付宝账号，是支付宝登录账号，格式一般是邮箱或手机号 (示例:alipay-test01@alipay.com)
	 * 是否必填(seller_id，seller_email，seller_account_name三个参数至少必须传递一个)
	 */
	private String seller_email;
	/**
	 * 卖家支付宝账号别名，是卖家支付宝账号别名 (示例:tstable02@alipay.com)
	 * 是否必填(seller_id，seller_email，seller_account_name三个参数至少必须传递一个)
	 */
	private String seller_account_name;
	/**
	 * 买家支付宝用户号 (示例:2088002007018955)
	 * 是否必填(否)
	 */
	private String buyer_id;
	/**
	 * 买家支付宝账号 (示例:tstable01@alipay.com)
	 * 是否必填(否)
	 */
	private String buyer_email;
	/**
	 * 买家支付宝账号别名 (示例:tstable03@alipay.com)
	 * 是否必填(否)
	 */
	private String buyer_account_name;
	/**
	 * 单位为：RMB Yuan。取值范围为[0.01，100000000.00]，精确到小数点后两位。此参数为单价
	 * 规则：price、quantity能代替total_fee。即存在total_fee，就不能存在price和quantity；存在price、
	 * quantity，就不能存在total_fee (示例:10.00) 
	 * 是否必填(否)
	 */
	private String price;
	/**
	 * price、quantity能代替total_fee。即存在total_fee，就不能存在price和quantity；存在price、quantity，就不能存在total_fee (示例:1)
	 * 是否必填(否)
	 */
	private String quantity;
	/**
	 * 对一笔交易的具体描述信息。如果是多种商品，请将商品描述字符串累加传给body (示例:美国专业护腕鼠标垫，舒缓式凝胶软垫模拟手腕的自然曲线和运动，创造和缓的GelFlex舒适地带！)
	 * 是否必填(否)
	 */
	private String body;
	/**
	 * 收银台页面上，商品展示的超链接 (示例:http://www.360buy.com/product/113714.html)
	 * 是否必填(否)
	 */
	private String show_url;
	/**
	 * 取值范围：creditPay（信用支付） directPay（余额支付） 如果不设置，默认识别为余额支付。
	 * 说明：必须注意区分大小写 (示例:directPay) 
	 * 是否必填(否)
	 */
	private String paymethod;
	/**
	 * 用于控制收银台支付渠道显示，该值的取值范围请参见支付渠道。 可支持多种支付渠道显示，以“^”分隔 (示例:directPay^bankPay^cartoon^cash) 
	 * 是否必填(否)
	 */
	private String enable_paymethod;
	/**
	 * 通过时间戳查询接口获取的加密支付宝系统时间戳。 如果已申请开通防钓鱼时间戳验证，则此字段必填 (示例:587FE3D2858E6B01E30104656E7805E2) 
	 * 是否必填(否)
	 */
	private String anti_phishing_key;
	/**
	 * 用户在创建交易时，该用户当前所使用机器的IP。 如果商户申请后台开通防钓鱼IP地址检查选项，此字段必填，校验用 (示例:128.214.222.111) 
	 * 是否必填(否)
	 */
	private String exter_invoke_ip;
	/**
	 * 如果用户请求时传递了该参数，则返回给商户时会回传该参数 (示例:你好，这是测试商户的广告)
	 * 是否必填(否)
	 */
	private String extra_common_param;
	/**
	 * 设置未付款交易的超时时间，一旦超时，该笔交易就会自动被关闭。当用户输入支付密码、点击确认付款后（即创建支付宝交易后）开始计时。
	 * 取值范围：1m～15d，或者使用绝对时间（示例格式：2014-06-13 16:00:00）。
	 * m-分钟，h-小时，d-天，1c-当天（1c-当天的情况下，无论交易何时创建，都在0点关闭）。
	 * 该参数数值不接受小数点，如1.5h，可转换为90m (示例:30m)
	 * 是否必填(否)
	 */
	private String it_b_pay;
	/**
	 * 如果开通了快捷登录产品，则需要填写；如果没有开通，则为空 (示例:201103290c9f9f2c03db4267a4c8e1bfe3adfd52)
	 * 是否必填(否)
	 */
	private String token;
	/**
	 * 扫码支付的方式，支持前置模式和跳转模式。
	 * 
	 * 前置模式是将二维码前置到商户的订单确认页的模式。需要商户在自己的页面中以iframe方式请求支付宝页面。具体分为以下3种：
	 * 
	 * 0：订单码-简约前置模式，对应iframe宽度不能小于600px，高度不能小于300px；
	 * 1：订单码-前置模式，对应iframe宽度不能小于300px，高度不能小于600px；
	 * 3：订单码-迷你前置模式，对应iframe宽度不能小于75px，高度不能小于75px。
	 * 跳转模式下，用户的扫码界面是由支付宝生成的，不在商户的域名下。
	 * 
	 * 2：订单码-跳转模式 
	 * (示例:1) 
	 * 是否必填(否)
	 */
	private String qr_pay_mode;
	/**
	 * 是否需要买家实名认证。
	 * 
	 * T表示需要买家实名认证； 不传或者传其它值表示不需要买家实名认证 (示例:T) 
	 * 是否必填(否)
	 */
	private String need_buyer_realnamed;

	public String getOut_trade_no() {
		return out_trade_no;
	}

	public void setOut_trade_no(String out_trade_no) {
		this.out_trade_no = out_trade_no;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getPayment_type() {
		return payment_type;
	}

	public void setPayment_type(String payment_type) {
		this.payment_type = payment_type;
	}

	public String getTotal_fee() {
		return total_fee;
	}

	public void setTotal_fee(String total_fee) {
		this.total_fee = total_fee;
	}

	public String getSeller_id() {
		return seller_id;
	}

	public void setSeller_id(String seller_id) {
		this.seller_id = seller_id;
	}

	public String getSeller_email() {
		return seller_email;
	}

	public void setSeller_email(String seller_email) {
		this.seller_email = seller_email;
	}

	public String getSeller_account_name() {
		return seller_account_name;
	}

	public void setSeller_account_name(String seller_account_name) {
		this.seller_account_name = seller_account_name;
	}

	public String getBuyer_id() {
		return buyer_id;
	}

	public void setBuyer_id(String buyer_id) {
		this.buyer_id = buyer_id;
	}

	public String getBuyer_email() {
		return buyer_email;
	}

	public void setBuyer_email(String buyer_email) {
		this.buyer_email = buyer_email;
	}

	public String getBuyer_account_name() {
		return buyer_account_name;
	}

	public void setBuyer_account_name(String buyer_account_name) {
		this.buyer_account_name = buyer_account_name;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public String getQuantity() {
		return quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getShow_url() {
		return show_url;
	}

	public void setShow_url(String show_url) {
		this.show_url = show_url;
	}

	public String getPaymethod() {
		return paymethod;
	}

	public void setPaymethod(String paymethod) {
		this.paymethod = paymethod;
	}

	public String getEnable_paymethod() {
		return enable_paymethod;
	}

	public void setEnable_paymethod(String enable_paymethod) {
		this.enable_paymethod = enable_paymethod;
	}

	public String getAnti_phishing_key() {
		return anti_phishing_key;
	}

	public void setAnti_phishing_key(String anti_phishing_key) {
		this.anti_phishing_key = anti_phishing_key;
	}

	public String getExter_invoke_ip() {
		return exter_invoke_ip;
	}

	public void setExter_invoke_ip(String exter_invoke_ip) {
		this.exter_invoke_ip = exter_invoke_ip;
	}

	public String getExtra_common_param() {
		return extra_common_param;
	}

	public void setExtra_common_param(String extra_common_param) {
		this.extra_common_param = extra_common_param;
	}

	public String getIt_b_pay() {
		return it_b_pay;
	}

	public void setIt_b_pay(String it_b_pay) {
		this.it_b_pay = it_b_pay;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getQr_pay_mode() {
		return qr_pay_mode;
	}

	public void setQr_pay_mode(String qr_pay_mode) {
		this.qr_pay_mode = qr_pay_mode;
	}

	public String getNeed_buyer_realnamed() {
		return need_buyer_realnamed;
	}

	public void setNeed_buyer_realnamed(String need_buyer_realnamed) {
		this.need_buyer_realnamed = need_buyer_realnamed;
	}

	@Override
	public String toString() {
		return "AlipayDirectPayRequest [getOut_trade_no()=" + getOut_trade_no() + ", getSubject()=" + getSubject()
				+ ", getPayment_type()=" + getPayment_type() + ", getTotal_fee()=" + getTotal_fee()
				+ ", getSeller_id()=" + getSeller_id() + ", getSeller_email()=" + getSeller_email()
				+ ", getSeller_account_name()=" + getSeller_account_name() + ", getBuyer_id()=" + getBuyer_id()
				+ ", getBuyer_email()=" + getBuyer_email() + ", getBuyer_account_name()=" + getBuyer_account_name()
				+ ", getPrice()=" + getPrice() + ", getQuantity()=" + getQuantity() + ", getBody()=" + getBody()
				+ ", getShow_url()=" + getShow_url() + ", getPaymethod()=" + getPaymethod() + ", getEnable_paymethod()="
				+ getEnable_paymethod() + ", getAnti_phishing_key()=" + getAnti_phishing_key()
				+ ", getExter_invoke_ip()=" + getExter_invoke_ip() + ", getExtra_common_param()="
				+ getExtra_common_param() + ", getIt_b_pay()=" + getIt_b_pay() + ", getToken()=" + getToken()
				+ ", getQr_pay_mode()=" + getQr_pay_mode() + ", getNeed_buyer_realnamed()=" + getNeed_buyer_realnamed()
				+ ", getService()=" + getService() + ", getPartner()=" + getPartner() + ", get_input_charset()="
				+ get_input_charset() + ", getSign_type()=" + getSign_type() + ", getSign()=" + getSign()
				+ ", getNotify_url()=" + getNotify_url() + ", getReturn_url()=" + getReturn_url() + "]";
	}

}
