package com.thebeastshop.pegasus.component.adaptor.payment.constants;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * 
 * @author Paul-xiong
 *
 */
public class AlipayStatusConstant {
	public static class Code {
		public static final String SUCCESS = "10000"; // 成功
		public static final String PAYING = "10003"; // 用户支付中
		public static final String FAILED = "40004"; // 失败
		public static final String ERROR = "20000"; // 系统异常
	}

	public static class TradeStatus {
		public static final String WAIT_BUYER_PAY = "WAIT_BUYER_PAY"; // 交易创建，等待买家付款
		public static final String FINISHED = "TRADE_FINISHED"; // 交易完成
		public static final String SUCCESS = "TRADE_SUCCESS"; // 交易成功
		public static final String CLOSED = "TRADE_CLOSED"; // 交易关闭
		public static final Set<String> QUERY_STATUS = new HashSet<>(Arrays.asList(FINISHED, SUCCESS, CLOSED)); // 如果查询到交易成功、交易结束、交易关闭，则返回对应结果
	}
}
