package com.thebeastshop.pegasus.component.adaptor.payment.config;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.config.PropertyConfigurer;

/* *
 *类名：AlipayConfig
 *功能：基础配置类
 *详细：设置帐户有关信息及返回路径
 *版本：3.4
 *修改日期：2016-03-08
 *说明：
 *以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 *该代码仅供学习和研究支付宝接口使用，只是提供一个参考。
 */

/**
 * @author Paul-xiong
 *
 */
public class AlipayConfig {

	// ↓↓↓↓↓↓↓↓↓↓请在这里配置您的基本信息↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓

	// API1.0（mapi）
	public static String API_1_0 = "https://mapi.alipay.com/gateway.do?";

	// API2.0（openapi）
	public static String API_2_0 = "https://openapi.alipay.com/gateway.do?";

	// 调用的接口版本，固定为：1.0
	public static String VERSION = "1.0";

	// 支付宝分配给开发者的应用Id
	public static String APP_ID = "2016032501242624"; // pro
	// public static String APP_ID = "2088602022427373"; // dev

	// 合作身份者ID，签约账号，以2088开头由16位纯数字组成的字符串，查看地址：https://b.alipay.com/order/pidAndKey.htm
	public static String PARTNER = "2088801125427095"; // 国内支付宝
	public static String CROSS_BORDER_PARTNER = "2088421407542861"; // 国际支付宝

	// 收款支付宝账号，以2088开头由16位纯数字组成的字符串，一般情况下收款账号就是签约账号
	public static String SELLER_ID = PARTNER; // 国内支付宝
	public static String CROSS_BORDER_SELLER_ID = CROSS_BORDER_PARTNER; // 国际支付宝

	// 商户的私钥,需要PKCS8格式，RSA公私钥生成：https://doc.open.alipay.com/doc2/detail.htm?spm=a219a.7629140.0.0.nBDxfy&treeId=58&articleId=103242&docType=1
	// 国内支付宝
	public static String PRIVATE_KEY = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJh5I+aYviWji0/0REeaFrfdlw0hFlEnC2HjrmiyE7MtettsR7tJp1enM+5JIcPXbUb3iqCHEnUoaiPfh889Squv7QiwW7dtQibWj5H0Vq0mZ6dHHKsXO8vuVQj99HPJ2ooIswFlpvLKqDM+kx3kERU0e9JPHbqT83pkrpXKt4+rAgMBAAECgYAAx4W+dQNrz9UzeG0s7IW3NOPDxmqFyaxOOMq4cEiXfuEE5B3NwEehtBIY4rjQdnZxiWxk+6vFe4pnWoooLgkGq59aWg9yySRym2aWW/mliR2efTt0nmHns/zRUu11lWOdQml5SQHDtwCib8yKBzc/bZqfakZCO2lf/PBBgb+gGQJBAMncwpuWrKmb3sn2Rvwe5v9xATy5hy4RbiCnl8V6emzZZivR6DSSTF48o6RMJ6ryjoP+7a0uROMNPJl3sOSQw4cCQQDBXXm6v894lOWWAKPy3TXnaxsS1eGNEFGomVXno50Dcb409roQ8nmD170fQ0Xijl5NGxBE9GwCM+HaT8WQdmO9AkAIfSQh7uAr8cYYsCakC5ijPVlT+Gla4pjC/sk/ILttQGcviJA/Rbe4bsxi6GDyq2ia3GmaUsvK0I+v1Hy33+6ZAkAb/nxxHPPccTIL1Wvm7T+wkUEKKQzOb15jGk/liTpiFUWERXQKoBAXllQ7AnJLqnDcmN5yHTDF4N0Bziq8D2fBAkEAnSEZ01iOp75mVOt1iyle4JYtiwBGkSwq3Hjahs/JBVj8x9RUgRh1LFaIqxs7XpirOtWOho0FUhGMU+Qccoii0g==";
	// 国际支付宝
	public static String CROSS_BORDER_PRIVATE_KEY = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAJh5I+aYviWji0/0REeaFrfdlw0hFlEnC2HjrmiyE7MtettsR7tJp1enM+5JIcPXbUb3iqCHEnUoaiPfh889Squv7QiwW7dtQibWj5H0Vq0mZ6dHHKsXO8vuVQj99HPJ2ooIswFlpvLKqDM+kx3kERU0e9JPHbqT83pkrpXKt4+rAgMBAAECgYAAx4W+dQNrz9UzeG0s7IW3NOPDxmqFyaxOOMq4cEiXfuEE5B3NwEehtBIY4rjQdnZxiWxk+6vFe4pnWoooLgkGq59aWg9yySRym2aWW/mliR2efTt0nmHns/zRUu11lWOdQml5SQHDtwCib8yKBzc/bZqfakZCO2lf/PBBgb+gGQJBAMncwpuWrKmb3sn2Rvwe5v9xATy5hy4RbiCnl8V6emzZZivR6DSSTF48o6RMJ6ryjoP+7a0uROMNPJl3sOSQw4cCQQDBXXm6v894lOWWAKPy3TXnaxsS1eGNEFGomVXno50Dcb409roQ8nmD170fQ0Xijl5NGxBE9GwCM+HaT8WQdmO9AkAIfSQh7uAr8cYYsCakC5ijPVlT+Gla4pjC/sk/ILttQGcviJA/Rbe4bsxi6GDyq2ia3GmaUsvK0I+v1Hy33+6ZAkAb/nxxHPPccTIL1Wvm7T+wkUEKKQzOb15jGk/liTpiFUWERXQKoBAXllQ7AnJLqnDcmN5yHTDF4N0Bziq8D2fBAkEAnSEZ01iOp75mVOt1iyle4JYtiwBGkSwq3Hjahs/JBVj8x9RUgRh1LFaIqxs7XpirOtWOho0FUhGMU+Qccoii0g==";

	// MD5密钥，安全检验码，由数字和字母组成的32位字符串，查看地址：https://b.alipay.com/order/pidAndKey.htm
	public static String MD5_KEY = "ny4oqhaq9dr2exxrgmkrrfuz4vjnyiw9"; // 国内支付宝KEY
	public static String CROSS_BORDER_MD5_KEY = "o2xugjbxngkjmaampjs11gva6v2e84ll"; // 国际支付宝KEY

	// 支付宝的公钥,查看地址：https://b.alipay.com/order/pidAndKey.htm
	public static String ALIPAY_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDDI6d306Q8fIfCOaTXyiUeJHkrIvYISRcc73s3vF1ZT7XN8RNPwJxo8pWaJMmvyTn9N4HQ632qJBVHf8sxHi/fEsraprwCtzvzQETrNRwVxLO5jVmRGi60j8Ue1efIlzPXV9je9mkjzOmdssymZkh2QhUrCmZYI/FCEa3/cNMW0QIDAQAB";

	// RSA签名方式
	public static String RSA_SIGN_TYPE = "RSA";

	// MD5签名方式
	public static String MD5_SIGN_TYPE = "MD5";

	// 调试用，创建TXT日志文件夹路径，见AlipayCore.java类中的logResult(String sWord)打印方法。
	public static String LOG_PATH = "C:\\";

	// 字符编码格式 目前支持 gbk 或 utf-8
	public static String CHARSET = "utf-8";

	// 支付类型 ，无需修改
	public static String PAYMENT_TYPE = "1";

	// 移动支付接口名称
	public static String MOBILE_PAY_SERVICE = "mobile.securitypay.pay";

	// 即时到账接口名称
	public static String DIRECT_PAY_SERVICE = "create_direct_pay_by_user";

	// 交易查询接口名称
	public static String TRADE_QUERY_METHOD = "alipay.trade.query";

	// App支付接口名称
	public static String APP_PAY_METHOD = "alipay.trade.app.pay";

	// ↑↑↑↑↑↑↑↑↑↑请在这里配置您的基本信息↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

	// ↓↓↓↓↓↓↓↓↓↓ 请在这里配置防钓鱼信息，如果没开通防钓鱼功能，为空即可 ↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓

	// 防钓鱼时间戳 若要使用请调用类文件submit中的query_timestamp函数
	public static String ANTI_PHISHING_KEY = "";

	// 客户端的IP地址 非局域网的外网IP地址，如：221.0.0.1
	public static String EXTER_INVOKE_IP = "";

	// ↑↑↑↑↑↑↑↑↑↑请在这里配置防钓鱼信息，如果没开通防钓鱼功能，为空即可 ↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

	static {
		PropertyConfigurer configurer = ComponentServiceLoader.getBean(PropertyConfigurer.class);
		if (configurer != null) {
			String appId = configurer.getProperty("alipay.app_id");
			if (StringUtils.isNotBlank(appId)) {
				APP_ID = appId;
			}
			String partner = configurer.getProperty("alipay.partner");
			if (StringUtils.isNotBlank(partner)) {
				PARTNER = partner;
			}
			String md5Key = configurer.getProperty("alipay.md5_key");
			if (StringUtils.isNotBlank(md5Key)) {
				MD5_KEY = md5Key;
			}
			String crossBorderPartner = configurer.getProperty("alipay.cross_border_partner");
			if (StringUtils.isNotBlank(crossBorderPartner)) {
				CROSS_BORDER_PARTNER = crossBorderPartner;
			}
			String crossBorderMd5Key = configurer.getProperty("alipay.cross_border_md5_key");
			if (StringUtils.isNotBlank(crossBorderMd5Key)) {
				CROSS_BORDER_MD5_KEY = crossBorderMd5Key;
			}
		}
	}

}
