package com.thebeastshop.pegasus.component.adaptor.logistics.domain.fedex;

import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * 联邦查询返回数据
 * 
 * @author Paul-xiong
 *
 */
@XmlRootElement(name = "fedex-express")
public class FedexResponse {
	private Tracking tracking;

	public Tracking getTracking() {
		return tracking;
	}

	public void setTracking(Tracking tracking) {
		this.tracking = tracking;
	}

	@Override
	public String toString() {
		return "FedexResponse [tracking=" + tracking + "]";
	}

	public static class Tracking {
		private Detail detail;

		public Detail getDetail() {
			return detail;
		}

		public void setDetail(Detail detail) {
			this.detail = detail;
		}

		@Override
		public String toString() {
			return "Tracking [detail=" + detail + "]";
		}

	}

	public static class Detail {
		/**
		 * 运单号
		 */
		private String tn;
		/**
		 * 主运单号
		 */
		private String ptn;
		/**
		 * 目的地
		 */
		private String destination;
		/**
		 * 寄件日期
		 */
		private String shipdate;
		/**
		 * 寄件人
		 */
		private String sentby;
		/**
		 * 收件人
		 */
		private String deliveredto;
		/**
		 * 签收人
		 */
		private String signedforby;
		/**
		 * 服务类型
		 */
		private String service;
		/**
		 * 收件日期
		 */
		private String deliverydate;
		/**
		 * 该货物最新状态
		 */
		private String status;
		/**
		 * 物流详细信息
		 */
		private FedexActivities activities;

		public String getTn() {
			return tn;
		}

		public void setTn(String tn) {
			this.tn = tn;
		}

		public String getPtn() {
			return ptn;
		}

		public void setPtn(String ptn) {
			this.ptn = ptn;
		}

		public String getDestination() {
			return destination;
		}

		public void setDestination(String destination) {
			this.destination = destination;
		}

		public String getShipdate() {
			return shipdate;
		}

		public void setShipdate(String shipdate) {
			this.shipdate = shipdate;
		}

		public String getSentby() {
			return sentby;
		}

		public void setSentby(String sentby) {
			this.sentby = sentby;
		}

		public String getDeliveredto() {
			return deliveredto;
		}

		public void setDeliveredto(String deliveredto) {
			this.deliveredto = deliveredto;
		}

		public String getSignedforby() {
			return signedforby;
		}

		public void setSignedforby(String signedforby) {
			this.signedforby = signedforby;
		}

		public String getService() {
			return service;
		}

		public void setService(String service) {
			this.service = service;
		}

		public String getDeliverydate() {
			return deliverydate;
		}

		public void setDeliverydate(String deliverydate) {
			this.deliverydate = deliverydate;
		}

		public String getStatus() {
			return status;
		}

		public void setStatus(String status) {
			this.status = status;
		}

		public FedexActivities getActivities() {
			return activities;
		}

		public void setActivities(FedexActivities activities) {
			this.activities = activities;
		}

		@Override
		public String toString() {
			return "Detail [tn=" + tn + ", ptn=" + ptn + ", destination=" + destination + ", shipdate=" + shipdate
					+ ", sentby=" + sentby + ", deliveredto=" + deliveredto + ", signedforby=" + signedforby
					+ ", service=" + service + ", deliverydate=" + deliverydate + ", status=" + status + ", activities="
					+ activities + "]";
		}

	}

	public static class FedexActivities {
		private List<FedexActivity> activity;

		public List<FedexActivity> getActivity() {
			return activity;
		}

		public void setActivity(List<FedexActivity> activity) {
			this.activity = activity;
		}

		@Override
		public String toString() {
			return "FedexActivities [activity=" + activity + "]";
		}

	}

	public static class FedexActivity {
		/**
		 * 该货物这次到达的时间
		 */
		private String datetime;
		/**
		 * 该货物这次运输的内容
		 */
		private String scan;
		/**
		 * 该货物这次运输的地方
		 */
		private String location;
		/**
		 * 该货物这次运输的详细描述
		 */
		private String details;

		public String getDatetime() {
			return datetime;
		}

		public void setDatetime(String datetime) {
			this.datetime = datetime;
		}

		public String getScan() {
			return scan;
		}

		public void setScan(String scan) {
			this.scan = scan;
		}

		public String getLocation() {
			return location;
		}

		public void setLocation(String location) {
			this.location = location;
		}

		public String getDetails() {
			return details;
		}

		public void setDetails(String details) {
			this.details = details;
		}

		@Override
		public String toString() {
			return "FedexActivity [datetime=" + datetime + ", scan=" + scan + ", location=" + location + ", details="
					+ details + "]";
		}

	}
}
