package com.thebeastshop.pegasus.component.adaptor.logistics.config;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.config.PropertyConfigurer;

/**
 * 顺丰快递配置信息
 * 
 * @author Paul-xiong
 *
 */
public class SFConfig {
	public static String ROUTE_SERVICE = "RouteService";// 路由服务编码

	public static String LANG_CN = "zh-CN";

	public static String ENVI_CODE = "shyp";// 线上环境编码
	// public static String ENVI_CODE = "BSPdevelop";// 开发环境编码；
	// public static String ENVI_CODE = "SHYP";// 测试环境编码

	public static String CHECKWORD = "EAYmRfpPyI5HJfaZ7yOtDf5ar2m6oVQq";// 线上环境编码
	// public static String CHECKWORD = "j8DzkIFgmlomPt0aLuwU";// 开发环境码
	// public static String CHECKWORD = "JB0LC2nhtDXq";// 测试环境编码

	public static String URL = "http://bsp-oisp.sf-express.com/bsp-oisp/sfexpressService";// 线上环境url
	// public static String URL =
	// "http://bspoisp.sit.sf-express.com:11080/bsp-oisp/sfexpressService";//
	// 开发环境url
	// public static String URL =
	// "http://218.17.248.244:11080/bsp-oisp/sfexpressService";// 测试环境url地址

	public static String METHOD_TYPE = "1";// 1：标准路由查询 tracking_type=2，则此值为客户订单号
	public static String TRACKING_TYPE = "1";// 1= 顺丰运单号 2：定制路由查询
	public static String RESPONSE_OK = "OK"; // 成功的返回
	public static String RESPONSE_ERROR = "ERR";// 错误的返回

	static {
		PropertyConfigurer configurer = ComponentServiceLoader.getBean(PropertyConfigurer.class);
		if (configurer != null) {
			String envi_code = configurer.getProperty("sf.envi_code");
			if (StringUtils.isNotBlank(envi_code)) {
				ENVI_CODE = envi_code;
			}
			String checkword = configurer.getProperty("sf.checkword");
			if (StringUtils.isNotBlank(checkword)) {
				CHECKWORD = checkword;
			}
			String url = configurer.getProperty("sf.url");
			if (StringUtils.isNotBlank(url)) {
				URL = url;
			}
		}
	}

}
