/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.support.config;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.stereotype.Component;

@Component
public class PropertyConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Logger log = LoggerFactory.getLogger(PropertyConfigurer.class);
    private Properties props;

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        this.props = props;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        return this.props.setProperty(key, value);
    }

    public String getEzrBaseUrl() {
        String ret = this.getProperty("constants.ezr.baseUrl");
        log.info("\u3010GET PROPERTY\u3011constants.ezr.baseUrl = {}", (Object)ret);
        return ret;
    }

    public String getEzrAppID() {
        String ret = this.getProperty("constants.ezr.app.id");
        log.info("\u3010GET PROPERTY\u3011constants.ezr.app.id = {}", (Object)ret);
        return ret;
    }

    public String getEzrToken() {
        String ret = this.getProperty("constants.ezr.token");
        log.info("\u3010GET PROPERTY\u3011constants.ezr.token = {}", (Object)ret);
        return ret;
    }

    public String getEzrAppSystem() {
        String ret = this.getProperty("constants.ezr.app.system");
        log.info("\u3010GET PROPERTY\u3011constants.ezr.app.system = {}", (Object)ret);
        return ret;
    }

    public String getChannelServiceURL() {
        String ret = this.getProperty("constants.cs_url");
        log.info("\u3010GET PROPERTY\u3011constants.cs_url = {}", (Object)ret);
        return ret;
    }

    public Map<String, String> getHttpParamMap() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appId", this.getEzrAppID());
        paramMap.put("token", this.getEzrToken());
        paramMap.put("appSystem", this.getEzrAppSystem());
        log.info("\u3010GET HTTP PARAM\u3011 paramMap:\uff5b\uff5d", (Object)JSON.toJSONString(paramMap));
        return paramMap;
    }
}

