/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.product.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.product.warehouse.service.ProductWarehouseService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleSaleInvVO;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductWarehouseServiceImpl
implements ProductWarehouseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String FLOWER_WAREHOUSE_CODE = "WH020600020002";
    private final Long FLOWER_CATEGORY_ID = 119L;
    private final List<String> IMMORTAL_FLOWER_SKU_CODES = Arrays.asList("11012520", "11012521");
    private PegasusWarehouseServiceFacade warehouseService = PegasusWarehouseServiceFacade.getInstance();
    private PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();
    @Autowired
    private McPsSkuService mcPsSkuService;

    private boolean checkIsFlower(PsSkuVO sku) {
        boolean flag = false;
        if (sku != null && (sku.getCategoryId() != null && sku.getCategoryId().equals(this.FLOWER_CATEGORY_ID) || this.IMMORTAL_FLOWER_SKU_CODES.contains(sku.getSkuCode()))) {
            flag = true;
        }
        return flag;
    }

    private boolean checkIsJIT(PsSkuVO sku) {
        boolean flag = false;
        if (sku != null && sku.getIsJit().equals(1)) {
            flag = true;
        }
        return flag;
    }

    private Map<PsSkuVO, Integer> mapJITSkuStock(List<PsSkuVO> skus, boolean isCombined) {
        if (!isCombined) {
            HashMap rt = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(skus)) {
                for (PsSkuVO sku : skus) {
                    if (sku == null || !this.checkIsJIT(sku)) continue;
                    rt.put(sku, Integer.MAX_VALUE);
                }
            }
            return rt;
        }
        return null;
    }

    private Map<PsSkuVO, Integer> mapPresaleSkuStock(List<PsSkuVO> skus, boolean isCombined, boolean isOversea) {
        if (!isCombined && !isOversea) {
            HashMap rt = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(skus)) {
                HashMap mapSkuCodes = Maps.newHashMap();
                for (PsSkuVO sku : skus) {
                    if (sku == null) continue;
                    mapSkuCodes.put(sku.getSkuCode(), sku);
                }
                Integer stock = 0;
                Map presaleMap = null;
                if (mapSkuCodes.size() > 0) {
                    ArrayList presaleSkuCodes = Lists.newArrayList(mapSkuCodes.keySet());
                    presaleMap = this.poInstance.findCanUseQttBySkuCodes((List)presaleSkuCodes);
                    for (String code : presaleSkuCodes) {
                        OpPresaleSaleInvVO presale = presaleMap != null ? (OpPresaleSaleInvVO)presaleMap.get(code) : null;
                        int presaleCount = presale == null ? 0 : presale.getCanUseInv();
                        stock = presaleCount;
                        PsSkuVO sku = (PsSkuVO)mapSkuCodes.get(code);
                        rt.put(sku, stock);
                    }
                }
            }
            return rt;
        }
        return null;
    }

    private Map<PsSkuVO, Integer> mapFlowerSkuStock(List<PsSkuVO> skus, boolean isCombined, boolean isOversea) {
        HashMap rt = Maps.newHashMap();
        HashMap mapSkuCodes = Maps.newHashMap();
        for (PsSkuVO sku : skus) {
            if (sku == null || this.checkIsJIT(sku) || !this.checkIsFlower(sku)) continue;
            mapSkuCodes.put(sku.getSkuCode(), sku);
        }
        Integer stock = 0;
        if (mapSkuCodes.keySet().size() > 0) {
            ArrayList skuCodes = Lists.newArrayList(mapSkuCodes.keySet());
            Map<PsSkuVO, Integer> presaleMap = this.mapPresaleSkuStock(Lists.newArrayList(mapSkuCodes.values()), isCombined, isOversea);
            Map map = this.warehouseService.findCanUseQttBySkuCodesAndWarehouseCode((List)skuCodes, "WH020600020002");
            for (String code : skuCodes) {
                PsSkuVO sku = (PsSkuVO)mapSkuCodes.get(code);
                WhInvVO warehouse = map != null ? (WhInvVO)map.get(code) : null;
                int presaleCount = presaleMap != null ? presaleMap.get(sku) : 0;
                int warehouseCount = warehouse == null ? 0 : warehouse.getCanUseInv();
                stock = presaleCount + warehouseCount;
                rt.put(sku, stock);
            }
        }
        return rt;
    }

    private Map<PsSkuVO, Integer> mapNormalSkuStock(List<PsSkuVO> skus, String warehouseCode, boolean isCombined, boolean isOversea) {
        HashMap rt = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skus)) {
            HashMap mapSkuCodes = Maps.newHashMap();
            for (PsSkuVO sku : skus) {
                if (sku == null || this.checkIsJIT(sku) || this.checkIsFlower(sku)) continue;
                mapSkuCodes.put(sku.getSkuCode(), sku);
            }
            Integer stock = 0;
            if (mapSkuCodes.keySet().size() > 0) {
                ArrayList skuCodes = Lists.newArrayList(mapSkuCodes.keySet());
                Map<PsSkuVO, Integer> presaleMap = this.mapPresaleSkuStock(Lists.newArrayList(mapSkuCodes.values()), isCombined, isOversea);
                Map map = this.warehouseService.findCanUseQttBySkuCodesAndWarehouseCode((List)skuCodes, warehouseCode);
                for (String code : skuCodes) {
                    PsSkuVO sku = (PsSkuVO)mapSkuCodes.get(code);
                    WhInvVO warehouse = map != null ? (WhInvVO)map.get(code) : null;
                    int presaleCount = presaleMap != null ? presaleMap.get(sku) : 0;
                    int warehouseCount = warehouse == null ? 0 : warehouse.getCanUseInv();
                    stock = presaleCount + warehouseCount;
                    rt.put(sku, stock);
                }
            }
        }
        return rt;
    }

    private Map<PsSkuVO, Integer> mapSkuStock(List<PsSkuVO> skus, String warehouseCode, boolean isCombined, boolean isOversea) {
        HashMap rt = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skus)) {
            Map<PsSkuVO, Integer> mapNormalSkuStock;
            Map<PsSkuVO, Integer> mapFlowerSkuStock;
            Map<PsSkuVO, Integer> mapJITSkuStock = this.mapJITSkuStock(skus, isCombined);
            if (mapJITSkuStock != null) {
                rt.putAll(mapJITSkuStock);
            }
            if ((mapFlowerSkuStock = this.mapFlowerSkuStock(skus, isCombined, isOversea)) != null) {
                rt.putAll(mapFlowerSkuStock);
            }
            if ((mapNormalSkuStock = this.mapNormalSkuStock(skus, warehouseCode, isCombined, isOversea)) != null) {
                rt.putAll(mapNormalSkuStock);
            }
        }
        return rt;
    }

    @Override
    public boolean isSellout(PsSpvVO spv, String warehouseCode) {
        if (spv != null) {
            Integer stock = this.getSpvStock(spv, warehouseCode);
            Integer minAmount = spv.getMinAmount() != null && spv.getMinAmount() != 0 ? spv.getMinAmount() : 1;
            if (stock != null && (stock <= 0 || stock / minAmount <= 0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer getSpvStock(PsSpvVO spv, String warehouseCode) {
        Map<PsSkuVO, Integer> mapSkuStock;
        Date start = new Date();
        Integer stock = null;
        ArrayList codes = Lists.newArrayList();
        HashMap skuQuantityMap = Maps.newHashMap();
        boolean isCombined = false;
        boolean isOversea = false;
        if (spv.getCombined().booleanValue()) {
            isCombined = true;
            List skuComns = spv.getSkuCombinationList();
            if (CollectionUtils.isNotEmpty((Collection)skuComns)) {
                for (PsSkuCombinationVO skuComn : skuComns) {
                    codes.add(skuComn.getSubSkuCode());
                    skuQuantityMap.put(skuComn.getSubSkuCode(), skuComn.getQuantity());
                }
            }
        } else {
            isCombined = false;
            codes.add(spv.getSkuCode());
        }
        List skus = this.mcPsSkuService.findBySkuCodes((List)codes);
        for (PsSkuVO sku : skus) {
            if (sku.getCrossBorderFlag() == null || !sku.getCrossBorderFlag().equals(1)) continue;
            isOversea = true;
            break;
        }
        if ((mapSkuStock = this.mapSkuStock(skus, warehouseCode, isCombined, isOversea)) != null && mapSkuStock.size() > 0) {
            for (Map.Entry<PsSkuVO, Integer> e : mapSkuStock.entrySet()) {
                Integer quantity;
                Integer tempStock = e.getValue();
                if (tempStock == null || tempStock < 0) {
                    tempStock = 0;
                }
                if ((quantity = (Integer)skuQuantityMap.get(e.getKey().getSkuCode())) != null && !quantity.equals(0)) {
                    tempStock = tempStock / quantity;
                }
                if (stock != null) {
                    if (stock <= tempStock) continue;
                    stock = tempStock;
                    continue;
                }
                stock = tempStock;
            }
        }
        Date end = new Date();
        this.logger.info("\u65b9\u6cd5getSpvStock\u82b1\u8d39\u65f6\u95f4\uff1a{}\u6beb\u79d2", (Object)(end.getTime() - start.getTime()));
        return stock != null ? stock : 0;
    }

    @Override
    public Map<PsSpvVO, Boolean> mapSpvsIsSellout(Collection<PsSpvVO> spvs, String warehouseCode) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (CollectionUtils.isNotEmpty(spvs)) {
            for (PsSpvVO spv : spvs) {
                map.put(spv, this.isSellout(spv, warehouseCode));
            }
        }
        return map;
    }

    @Override
    public Map<PsSpvVO, Integer> mapSpvsStock(Collection<PsSpvVO> spvs, String warehouseCode) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (CollectionUtils.isNotEmpty(spvs)) {
            for (PsSpvVO spv : spvs) {
                map.put(spv, this.getSpvStock(spv, warehouseCode));
            }
        }
        return map;
    }
}

