/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.price;

import com.thebeastshop.pegasus.component.product.pack.ProductPack;
import com.thebeastshop.support.util.PriceUtil;
import java.math.BigDecimal;
import java.util.Map;

public class PriceCalculatorUtil {
    public static BigDecimal sumAllPrice(Map<ProductPack, BigDecimal> priceMap) {
        BigDecimal allPrice = BigDecimal.ZERO;
        for (Map.Entry<ProductPack, BigDecimal> entry : priceMap.entrySet()) {
            allPrice = allPrice.add(entry.getValue().multiply(BigDecimal.valueOf(entry.getKey().getCount())));
        }
        return PriceUtil.keepToCent((BigDecimal)allPrice);
    }

    public static Map<ProductPack, BigDecimal> shareDiscount(BigDecimal savedPrice, Map<ProductPack, BigDecimal> priceMap) {
        if (savedPrice.compareTo(BigDecimal.ZERO) == 0) {
            return priceMap;
        }
        return PriceUtil.shareDiscount(priceMap, (BigDecimal)savedPrice);
    }
}

