/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.price;

import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.member.domain.Member;
import com.thebeastshop.pegasus.component.price.PriceCalculateContext;
import com.thebeastshop.pegasus.component.price.PriceCalculateContextForPacks;
import com.thebeastshop.pegasus.component.price.PriceCalculator;
import com.thebeastshop.pegasus.component.product.pack.ProductPack;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.util.EnumUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MemberLevelPriceCalculator
implements PriceCalculator {
    @Autowired
    private McPsProductService mcPsProductService;

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Map<ProductPack, BigDecimal> calculate(PriceCalculateContext context) {
        Member member = context.getMember();
        if (context instanceof PriceCalculateContextForPacks) {
            PriceCalculateContextForPacks contextForPacks = (PriceCalculateContextForPacks)context;
            List<? extends ProductPack> packs = contextForPacks.getPacks();
            MemberLevel level = (MemberLevel)EnumUtil.valueOf((Comparable)member.getMemberLevel(), MemberLevel.class);
            if (level != null && CollectionUtils.isNotEmpty(packs)) {
                HashMap rt = Maps.newHashMapWithExpectedSize((int)packs.size());
                for (ProductPack productPack : packs) {
                    rt.put(productPack, productPack.getFactProductPrice());
                }
                ArrayList<String> productIds = new ArrayList<String>();
                for (ProductPack productPack : packs) {
                    productIds.add(productPack.getProductId().toString());
                }
                Map map = this.mcPsProductService.mapByProdIds(productIds);
                for (ProductPack productPack : packs) {
                    PsProductVO product = (PsProductVO)map.get(productPack.getProductId().toString());
                    if (null == product || product.getAllowVipDiscount() == null || !product.getAllowVipDiscount().equals(1)) continue;
                    BigDecimal discount = level.getLevelAmountCondition().multiply(productPack.getFactProductPrice());
                    productPack.setFactProductPrice(discount);
                    rt.put(productPack, discount);
                }
                return rt;
            }
        }
        return context.getPackAndOriginalPrice();
    }
}

