/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.price;

import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.impl.FullCutCouponImpl;
import com.thebeastshop.pegasus.component.price.PriceCalculateContext;
import com.thebeastshop.pegasus.component.price.PriceCalculateContextForOrder;
import com.thebeastshop.pegasus.component.price.PriceCalculator;
import com.thebeastshop.pegasus.component.price.PriceCalculatorUtil;
import com.thebeastshop.pegasus.component.product.pack.ProductPack;
import java.math.BigDecimal;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class CouponPriceCalculator
implements PriceCalculator {
    @Override
    public Map<ProductPack, BigDecimal> calculate(PriceCalculateContext context) {
        PriceCalculateContextForOrder priceCalculateContextForOrder;
        Coupon coupon;
        Map<ProductPack, BigDecimal> prePriceMap = context.getPackAndOriginalPrice();
        if (context instanceof PriceCalculateContextForOrder && (coupon = (priceCalculateContextForOrder = (PriceCalculateContextForOrder)context).getCoupon()) instanceof FullCutCouponImpl) {
            FullCutCouponImpl fullCutCoupon = (FullCutCouponImpl)coupon;
            BigDecimal savedPrice = fullCutCoupon.getCutPrice();
            return PriceCalculatorUtil.shareDiscount(savedPrice, prePriceMap);
        }
        return prePriceMap;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

