/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.price;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.member.domain.Member;
import com.thebeastshop.pegasus.component.price.PriceCalculateContext;
import com.thebeastshop.pegasus.component.price.PriceCalculator;
import com.thebeastshop.pegasus.component.product.pack.ProductPack;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class BirthdayPriceCalculator
implements PriceCalculator {
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<ProductPack, BigDecimal> calculate(PriceCalculateContext context) {
        HashMap rt = Maps.newHashMap();
        if (context != null && context.getMember() != null && context.getMember().isInBdayDiscountTime()) {
            Member member = context.getMember();
            Map<ProductPack, BigDecimal> prePriceMap = context.getPackAndOriginalPrice();
            ArrayList productPacks = Lists.newArrayList(prePriceMap.keySet());
            for (ProductPack productPack : productPacks) {
                BigDecimal discountRatio = member.getBdayDiscountRatio();
                BigDecimal prePrice = prePriceMap.get(productPack);
                rt.put(productPack, prePrice.multiply(discountRatio));
            }
        }
        return rt;
    }
}

