/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member.service.impl;

import com.thebeastshop.member.point.service.MemberPointService;
import com.thebeastshop.pegasus.component.member.condition.MemberCondition;
import com.thebeastshop.pegasus.component.member.dao.MemberEntityMapper;
import com.thebeastshop.pegasus.component.member.domain.Member;
import com.thebeastshop.pegasus.component.member.model.MemberEntity;
import com.thebeastshop.pegasus.component.member.model.MemberEntityExample;
import com.thebeastshop.pegasus.component.member.service.BaseService;
import com.thebeastshop.pegasus.component.member.service.MemberService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.NameValuePair;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="memberService")
public class MemberServiceImpl
extends BaseService
implements MemberService {
    @Autowired
    private MemberEntityMapper memberEntityMapper;
    @Autowired
    private MemberPointService memberPointService;

    private Member entity2Domain(MemberEntity entity) {
        if (entity != null) {
            Member member = (Member)BeanUtil.buildFrom((Object)entity, Member.class);
            member.setPoint(this.memberPointService.findCommonValidMemberLevelByparam(member.getId(), member.getCode()));
            if (member.getMemberLevel() == null || member.getMemberLevel() != null && member.getStartupLevel() != null && member.getStartupLevel() > member.getMemberLevel()) {
                member.setMemberLevel(member.getStartupLevel());
            }
            return member;
        }
        return null;
    }

    @Override
    public Member create(Member member) {
        this.logger.info("Creating Member: {}", (Object)member);
        MemberEntity entity = (MemberEntity)BeanUtil.buildFrom((Object)member, MemberEntity.class);
        if (entity != null) {
            int count = this.memberEntityMapper.insert(entity);
            member.setId(entity.getId());
            this.logger.info("Created Member: {}", (Object)member);
            if (count > 0) {
                return member;
            }
        }
        return null;
    }

    @Override
    public boolean update(Member member) {
        this.logger.info("Updating Member: {}", (Object)member);
        MemberEntity entity = (MemberEntity)BeanUtil.buildFrom((Object)member, MemberEntity.class);
        if (entity != null) {
            int count = this.memberEntityMapper.updateByPrimaryKeySelective(entity);
            this.logger.info("Updated Member: {}", (Object)member);
            if (count > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Member getById(long id) {
        MemberEntity entity = this.memberEntityMapper.selectByPrimaryKey(id);
        return this.entity2Domain(entity);
    }

    @Override
    public Member getByCode(String code) {
        MemberCondition condition = new MemberCondition();
        condition.setCode(code);
        List<Member> list = this.findByCondition(condition);
        if (list.size() > 1) {
            throw new WrongArgException("\u6839\u636e\u4e00\u4e2amemberCode\u80fd\u641c\u5230\u591a\u4e2a", new NameValuePair[0]);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<Member> findByCondition(MemberCondition condition) {
        List<MemberEntity> members;
        List list = null;
        MemberEntityExample loginExample = new MemberEntityExample();
        MemberEntityExample.Criteria criteria = loginExample.createCriteria();
        if (StringUtils.isNotBlank((String)condition.getCode())) {
            criteria.andCodeEqualTo(condition.getCode());
        }
        if (StringUtils.isNotBlank((String)condition.getVerifiedMobile())) {
            criteria.andVerifiedMobileEqualTo(condition.getVerifiedMobile());
        }
        if (CollectionUtils.isNotEmpty(members = this.memberEntityMapper.selectByExample(loginExample))) {
            list = BeanUtil.buildListFrom(members, Member.class);
        }
        if (list != null) {
            for (Member member : list) {
                if (member.getMemberLevel() != null && (member.getMemberLevel() == null || member.getStartupLevel() == null || member.getStartupLevel() <= member.getMemberLevel())) continue;
                member.setMemberLevel(member.getStartupLevel());
            }
        }
        return list;
    }

    @Override
    public Member check(Long id) {
        if (id == null) {
            throw new WrongArgException("\u672a\u6307\u5b9a\u4f1a\u5458id", "id", (Object)id);
        }
        Member one = this.getById(id);
        if (one == null) {
            throw new NoSuchResourceException("\u4f1a\u5458", (Object)id);
        }
        return one;
    }
}

