/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.member.condition.MemberLoginCondition;
import com.thebeastshop.pegasus.component.member.dao.MemberLoginEntityMapper;
import com.thebeastshop.pegasus.component.member.domain.MemberLogin;
import com.thebeastshop.pegasus.component.member.model.MemberLoginEntity;
import com.thebeastshop.pegasus.component.member.model.MemberLoginEntityExample;
import com.thebeastshop.pegasus.component.member.service.BaseService;
import com.thebeastshop.pegasus.component.member.service.MemberLoginService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.support.enums.LoginType;
import com.thebeastshop.support.util.EnumUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="memberLoginService")
public class MemberLoginServiceImpl
extends BaseService
implements MemberLoginService {
    @Autowired
    private MemberLoginEntityMapper memberLoginEntityMapper;

    private void fillCriteria(MemberLoginCondition condition, MemberLoginEntityExample.Criteria criteria) {
        if (NullUtil.isNotNull((Object)condition.getMemberId())) {
            criteria.andMemberIdEqualTo(condition.getMemberId());
        }
        if (NullUtil.isNotNull((Object)condition.getMemberIdNot())) {
            criteria.andMemberIdNotEqualTo(condition.getMemberIdNot());
        }
        if (StringUtils.isNotBlank((String)condition.getLoginId())) {
            criteria.andLoginIdEqualTo(condition.getLoginId());
        }
        if (NullUtil.isNotNull((Object)condition.getLoginType())) {
            criteria.andLoginTypeEqualTo(condition.getLoginType().getId());
        }
        if (StringUtils.isNotBlank((String)condition.getUnionId())) {
            criteria.andUnionIdEqualTo(condition.getUnionId());
        }
    }

    private MemberLogin entity2Domain(MemberLoginEntity entity) {
        if (entity != null) {
            MemberLogin domain = (MemberLogin)BeanUtil.buildFrom((Object)entity, MemberLogin.class);
            domain.setLoginType((LoginType)EnumUtil.valueOf((Comparable)entity.getLoginType(), LoginType.class));
            return domain;
        }
        return null;
    }

    private List<MemberLogin> entity2Domain(List<MemberLoginEntity> entities) {
        ArrayList domains = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (MemberLoginEntity entity : entities) {
                domains.add(this.entity2Domain(entity));
            }
        }
        return domains;
    }

    private MemberLoginEntity domain2Entity(MemberLogin domain) {
        if (domain != null) {
            MemberLoginEntity entity = (MemberLoginEntity)BeanUtil.buildFrom((Object)domain, MemberLoginEntity.class);
            entity.setLoginType(domain.getLoginType().getId());
            return entity;
        }
        return null;
    }

    @Override
    public MemberLogin create(MemberLogin memberLogin) {
        this.logger.info("Creating MemberLogin: {}", (Object)memberLogin);
        MemberLoginEntity entity = this.domain2Entity(memberLogin);
        if (entity != null) {
            int count = this.memberLoginEntityMapper.insert(entity);
            memberLogin.setId(entity.getId());
            this.logger.info("Created MemberLogin: {}", (Object)memberLogin);
            if (count > 0) {
                return memberLogin;
            }
        }
        return null;
    }

    @Override
    public boolean update(MemberLogin memberLogin) {
        this.logger.info("Updating MemberLogin: {}", (Object)memberLogin);
        MemberLoginEntity entity = this.domain2Entity(memberLogin);
        if (entity != null) {
            int count = this.memberLoginEntityMapper.updateByPrimaryKeySelective(entity);
            this.logger.info("Updated MemberLogin: {}", (Object)memberLogin);
            if (count > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean delete(Long id) {
        boolean result;
        MemberLogin login = this.getById(id);
        if (login == null) {
            return false;
        }
        this.logger.info("Deleting MemberLogin: {}", (Object)login);
        boolean bl = result = this.memberLoginEntityMapper.deleteByPrimaryKey(id) != 0;
        if (result) {
            this.logger.info("Deleted MemberLogin: {}", (Object)login);
        }
        return result;
    }

    @Override
    public MemberLogin getById(long id) {
        return this.entity2Domain(this.memberLoginEntityMapper.selectByPrimaryKey(id));
    }

    @Override
    public List<MemberLogin> getByMemberId(long id) {
        MemberLoginCondition condition = new MemberLoginCondition();
        condition.setMemberId(id);
        return this.findByCondition(condition);
    }

    @Override
    public List<MemberLogin> findByCondition(MemberLoginCondition condition) {
        MemberLoginEntityExample loginExample = new MemberLoginEntityExample();
        MemberLoginEntityExample.Criteria criteria = loginExample.createCriteria();
        this.fillCriteria(condition, criteria);
        List<MemberLoginEntity> entities = this.memberLoginEntityMapper.selectByExample(loginExample);
        return this.entity2Domain(entities);
    }
}

