/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.member.condition.MemberLoginHistoryCondition;
import com.thebeastshop.pegasus.component.member.dao.MemberLoginHistoryEntityMapper;
import com.thebeastshop.pegasus.component.member.domain.MemberLoginHistory;
import com.thebeastshop.pegasus.component.member.model.MemberLoginHistoryEntity;
import com.thebeastshop.pegasus.component.member.model.MemberLoginHistoryEntityExample;
import com.thebeastshop.pegasus.component.member.service.BaseService;
import com.thebeastshop.pegasus.component.member.service.MemberLoginHistoryService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.util.EnumUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="memberLoginHistoryService")
public class MemberLoginHistoryServiceImpl
extends BaseService
implements MemberLoginHistoryService {
    @Autowired
    private MemberLoginHistoryEntityMapper memberLoginHistroyEntityMapper;

    private void fillCriteria(MemberLoginHistoryCondition condition, MemberLoginHistoryEntityExample.Criteria criteria) {
        if (condition.getMemberId() != null) {
            criteria.andMemberIdEqualTo(condition.getMemberId());
        }
        if (condition.getMemberLoginId() != null) {
            criteria.andMemberLoginIdEqualTo(condition.getMemberLoginId());
        }
        if (condition.getAccessWay() != null) {
            criteria.andAccessWayEqualTo(condition.getAccessWay().getId());
        }
    }

    private MemberLoginHistory entity2Domain(MemberLoginHistoryEntity entity) {
        if (entity != null) {
            MemberLoginHistory domain = (MemberLoginHistory)BeanUtil.buildFrom((Object)entity, MemberLoginHistory.class);
            domain.setAccessWay((AccessWay)EnumUtil.valueOf((Comparable)entity.getAccessWay(), AccessWay.class));
            return domain;
        }
        return null;
    }

    private List<MemberLoginHistory> entity2Domain(List<MemberLoginHistoryEntity> entities) {
        ArrayList domains = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (MemberLoginHistoryEntity entity : entities) {
                domains.add(this.entity2Domain(entity));
            }
        }
        return domains;
    }

    private MemberLoginHistoryEntity domain2Entity(MemberLoginHistory domain) {
        if (domain != null) {
            MemberLoginHistoryEntity entity = (MemberLoginHistoryEntity)BeanUtil.buildFrom((Object)domain, MemberLoginHistoryEntity.class);
            entity.setAccessWay(domain.getAccessWay().getId());
            return entity;
        }
        return null;
    }

    @Override
    public MemberLoginHistory create(MemberLoginHistory obj) {
        this.logger.info("Creating MemberLoginHistory: {}", (Object)obj);
        obj.setLoginTime(new Date());
        MemberLoginHistoryEntity entity = this.domain2Entity(obj);
        if (entity != null) {
            int count = this.memberLoginHistroyEntityMapper.insert(entity);
            obj.setId(entity.getId());
            this.logger.info("Created MemberLoginHistory: {}", (Object)obj);
            if (count > 0) {
                return obj;
            }
        }
        return null;
    }

    @Override
    public MemberLoginHistory getById(long id) {
        return this.entity2Domain(this.memberLoginHistroyEntityMapper.selectByPrimaryKey(id));
    }

    @Override
    public List<MemberLoginHistory> getByMemberId(long id) {
        MemberLoginHistoryCondition condition = new MemberLoginHistoryCondition();
        condition.setMemberId(id);
        return this.findByCondition(condition);
    }

    @Override
    public List<MemberLoginHistory> findByCondition(MemberLoginHistoryCondition condition) {
        MemberLoginHistoryEntityExample loginExample = new MemberLoginHistoryEntityExample();
        MemberLoginHistoryEntityExample.Criteria criteria = loginExample.createCriteria();
        this.fillCriteria(condition, criteria);
        List<MemberLoginHistoryEntity> entities = this.memberLoginHistroyEntityMapper.selectByExample(loginExample);
        return this.entity2Domain(entities);
    }
}

