/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.member.dao.MemberAddressEntityMapper;
import com.thebeastshop.pegasus.component.member.domain.MemberAddress;
import com.thebeastshop.pegasus.component.member.model.MemberAddressEntity;
import com.thebeastshop.pegasus.component.member.model.MemberAddressEntityExample;
import com.thebeastshop.pegasus.component.member.service.BaseService;
import com.thebeastshop.pegasus.component.member.service.MemberAddressService;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.model.CommDistrict;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="memberAddressService")
public class MemberAddressServiceImpl
extends BaseService
implements MemberAddressService {
    @Autowired
    private MemberAddressEntityMapper memberAddressEntityMapper;

    private MemberAddressEntity address2entity(MemberAddress address) {
        MemberAddressEntity entity = null;
        if (address != null && address.getDistrict() != null) {
            entity = (MemberAddressEntity)BeanUtil.buildFrom((Object)address, MemberAddressEntity.class, (String[])new String[]{"district"});
            entity.setDistrictId(address.getDistrict().getId());
            entity.setDistrict(address.getDistrict().getName());
            entity.setAsdefault(address.getAsDefault());
        }
        return entity;
    }

    private MemberAddress entity2Address(MemberAddressEntity entity) {
        MemberAddress address = null;
        if (entity != null) {
            CommDistrict commonDistrict;
            address = (MemberAddress)BeanUtil.buildFrom((Object)entity, MemberAddress.class, (String[])new String[]{"district"});
            address.setAsDefault(entity.getAsdefault());
            if (entity.getDistrictId() != null && entity.getDistrictId() > 0L && (commonDistrict = PegasusUtilFacade.getInstance().findDistrictById(entity.getDistrictId())) != null) {
                address.getDistrict().setId(commonDistrict.getId());
                address.getDistrict().setName(commonDistrict.getName());
                address.getDistrict().setFullName(commonDistrict.getFullName());
            }
        }
        return address;
    }

    @Override
    public MemberAddress create(MemberAddress address) {
        this.logger.info("Creating MemberAddress: {}", (Object)address);
        MemberAddressEntity entity = this.address2entity(address);
        if (entity != null) {
            CommDistrict commonDistrict = PegasusUtilFacade.getInstance().findDistrictById(entity.getDistrictId());
            int count = this.memberAddressEntityMapper.insert(entity);
            address.setId(entity.getId());
            if (null != commonDistrict) {
                address.getDistrict().setId(commonDistrict.getId());
                address.getDistrict().setName(commonDistrict.getName());
                address.getDistrict().setFullName(commonDistrict.getFullName());
            }
            this.logger.info("Created MemberAddress: {}", (Object)address);
            if (count > 0) {
                return address;
            }
        }
        return null;
    }

    @Override
    public boolean update(MemberAddress address) {
        this.logger.info("Updating MemberAddress: {}", (Object)address);
        MemberAddressEntity entity = this.address2entity(address);
        if (entity != null) {
            CommDistrict commonDistrict = PegasusUtilFacade.getInstance().findDistrictById(entity.getDistrictId());
            int count = this.memberAddressEntityMapper.updateByPrimaryKeySelective(entity);
            address.getDistrict().setId(commonDistrict.getId());
            address.getDistrict().setName(commonDistrict.getName());
            address.getDistrict().setFullName(commonDistrict.getFullName());
            this.logger.info("Updated MemberAddress: {}", (Object)address);
            if (count > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean delete(Long id) {
        this.logger.info("Deleting MemberAddress: {}", (Object)id);
        int count = this.memberAddressEntityMapper.deleteByPrimaryKey(id);
        this.logger.info("Deleted MemberAddress: {}", (Object)id);
        return count > 0;
    }

    @Override
    public MemberAddress getById(Long id) {
        MemberAddress address = null;
        MemberAddressEntity entity = this.memberAddressEntityMapper.selectByPrimaryKey(id);
        if (entity != null) {
            address = this.entity2Address(entity);
        }
        return address;
    }

    @Override
    public List<MemberAddress> list(Long memberId) {
        ArrayList<MemberAddress> list = Lists.newArrayList();
        MemberAddressEntityExample example = new MemberAddressEntityExample();
        example.createCriteria().andMemberIdEqualTo(memberId);
        example.setOrderByClause(" ID desc");
        List<MemberAddressEntity> maeList = this.memberAddressEntityMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(maeList)) {
            list = new ArrayList<MemberAddress>();
            MemberAddress ma = null;
            for (MemberAddressEntity mae : maeList) {
                ma = this.entity2Address(mae);
                if (ma == null) continue;
                list.add(ma);
            }
        }
        return list;
    }

    @Override
    public MemberAddress getDefaultByOwnerId(Long ownerId) {
        MemberAddressEntityExample example = new MemberAddressEntityExample();
        example.createCriteria().andMemberIdEqualTo(ownerId).andAsdefaultEqualTo(true);
        List<MemberAddressEntity> entities = this.memberAddressEntityMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(entities)) {
            return this.entity2Address(entities.get(0));
        }
        return null;
    }
}

