/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member.service.impl;

import com.thebeastshop.pegasus.component.member.dao.FeedbackEntityMapper;
import com.thebeastshop.pegasus.component.member.domain.Feedback;
import com.thebeastshop.pegasus.component.member.enums.Status;
import com.thebeastshop.pegasus.component.member.model.FeedbackEntity;
import com.thebeastshop.pegasus.component.member.service.BaseService;
import com.thebeastshop.pegasus.component.member.service.FeedbackService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="feedbackService")
public class FeedbackServiceImpl
extends BaseService
implements FeedbackService {
    @Autowired
    private FeedbackEntityMapper feedbackEntityMapper;

    @Override
    public Feedback create(Feedback feedback) {
        this.logger.info("Creating feedback: {}", (Object)feedback);
        feedback.setStatus(Status.NORMAL.getId());
        feedback.setCreateTime(new Date());
        feedback.setUpdateTime(new Date());
        FeedbackEntity entity = (FeedbackEntity)BeanUtil.buildFrom((Object)feedback, FeedbackEntity.class);
        if (entity != null) {
            int count = this.feedbackEntityMapper.insertSelective(entity);
            feedback.setId(entity.getId());
            this.logger.info("Created feedback: {}", (Object)feedback);
            if (count > 0) {
                return feedback;
            }
        }
        return null;
    }

    @Override
    public boolean update(Feedback feedback) {
        this.logger.info("Updating feedback: {}", (Object)feedback);
        FeedbackEntity entity = (FeedbackEntity)BeanUtil.buildFrom((Object)feedback, FeedbackEntity.class);
        entity.setUpdateTime(new Date());
        if (entity != null) {
            int count = this.feedbackEntityMapper.updateByPrimaryKeySelective(entity);
            this.logger.info("Updated feedback: {}", (Object)feedback);
            if (count > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean delete(Long id) {
        this.logger.info("Deleting feedback: {}", (Object)id);
        Feedback feedback = new Feedback();
        feedback.setId(id);
        feedback.setStatus(Status.DELETED.getId());
        if (this.update(feedback)) {
            this.logger.info("Deleted feedback: {}", (Object)feedback);
            return true;
        }
        return false;
    }

    @Override
    public Feedback getById(long id) {
        Feedback feedback = (Feedback)BeanUtil.buildFrom((Object)this.feedbackEntityMapper.selectByPrimaryKey(id), Feedback.class);
        if (feedback.getStatus().equals(Status.DELETED.getId())) {
            return null;
        }
        return feedback;
    }
}

