/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member.service.business.impl;

import com.thebeastshop.pegasus.component.member.dao.MemberEntityMapper;
import com.thebeastshop.pegasus.component.member.dao.MemberLoginEntityMapper;
import com.thebeastshop.pegasus.component.member.dao.MemberMergeMapper;
import com.thebeastshop.pegasus.component.member.domain.Member;
import com.thebeastshop.pegasus.component.member.domain.MemberLogin;
import com.thebeastshop.pegasus.component.member.enums.Status;
import com.thebeastshop.pegasus.component.member.model.MemberLoginEntity;
import com.thebeastshop.pegasus.component.member.model.MemberLoginEntityExample;
import com.thebeastshop.pegasus.component.member.service.MemberLoginService;
import com.thebeastshop.pegasus.component.member.service.MemberService;
import com.thebeastshop.pegasus.component.member.service.business.IMemberMergeLogic;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.support.enums.LoginType;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.exception.BusinessLogicNotExpectedException;
import com.thebeastshop.support.exception.UnknownException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="memberMergeLogic")
public class MemberMergeLogic
implements IMemberMergeLogic {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberLoginService memberLoginService;
    @Autowired
    private MemberEntityMapper memberEntityMapper;
    @Autowired
    private MemberLoginEntityMapper memberLoginEntityMapper;
    @Autowired
    private MemberMergeMapper memberMergeMapper;

    @Override
    @Transactional
    public synchronized boolean mergeMember(Long mainMemberId, Long subMemberId) {
        this.logger.info("\u5408\u5e76\u4f1a\u5458 \u53c2\u6570 = mainMemberId: {},subMemberId: {}", (Object)mainMemberId, (Object)subMemberId);
        Member _mainMember = this.memberService.check(mainMemberId);
        Member _subMember = this.memberService.check(subMemberId);
        this.beforeMerge(_mainMember, _subMember);
        this.merge(_mainMember, _subMember);
        this.afterMerge(_mainMember, _subMember);
        return true;
    }

    private void beforeMerge(Member mainMember, Member subMember) {
        if (mainMember.getId().equals(subMember.getId())) {
            throw new BusinessLogicNotExpectedException("\u4e3b\u4f1a\u5458\u4e0e\u5f85\u5408\u5e76\u7684\u4f1a\u5458id\u4e00\u81f4,\u4e0d\u80fd\u5408\u5e76\u540c\u4e00\u4e2a\u4f1a\u5458");
        }
        if (EmptyUtil.isNotEmpty((String)subMember.getMergeTo())) {
            throw new BusinessLogicNotExpectedException("\u5df2\u88ab\u5408\u5e76\u8fc7\u7684\u4f1a\u5458\u65e0\u6cd5\u518d\u88ab\u5408\u5e76");
        }
        if (EmptyUtil.isEmpty((String)mainMember.getCode())) {
            throw new BusinessLogicNotExpectedException("\u4e3b\u4f1a\u5458\u65e0\u7f16\u53f7");
        }
        if (EmptyUtil.isEmpty((String)subMember.getCode())) {
            throw new BusinessLogicNotExpectedException("\u5f85\u5408\u5e76\u4f1a\u5458\u65e0\u7f16\u53f7");
        }
    }

    private void merge(Member mainMember, Member subMember) {
        mainMember.setStartupLevel(Math.max(mainMember.getStartupLevel(), subMember.getStartupLevel()));
        this.memberService.update(mainMember);
        subMember.setMemberStatus(Status.INVALID.getId());
        subMember.setMergeTo(mainMember.getCode());
        this.memberService.update(subMember);
        boolean conflict = false;
        List<MemberLogin> mainMemberLogins = this.memberLoginService.getByMemberId(mainMember.getId());
        List<MemberLogin> subMemberLogins = this.memberLoginService.getByMemberId(subMember.getId());
        block0: for (MemberLogin mainMemberLogin : mainMemberLogins) {
            for (MemberLogin subMemberLogin : subMemberLogins) {
                if (!mainMemberLogin.getLoginType().equals((Object)subMemberLogin.getLoginType()) || !mainMemberLogin.getLoginId().trim().toLowerCase().equals(subMemberLogin.getLoginId().trim().toLowerCase())) continue;
                conflict = true;
                continue block0;
            }
        }
        if (conflict) {
            this.logger.info("\u5408\u5e76\u4f1a\u5458 \u53c2\u6570 = mainMemberId: {},subMemberId: {},\u767b\u9646\u65b9\u5f0f\u6709\u51b2\u7a81", (Object)mainMember.getId(), (Object)subMember.getId());
            throw new BusinessLogicNotExpectedException("\u4e3b\u4f1a\u5458\u4e0e\u5f85\u5408\u5e76\u4f1a\u5458\u767b\u9646\u65b9\u5f0f\u6709\u51b2\u7a81");
        }
        this.memberMergeMapper.mergeLogin(mainMember.getId(), subMember.getId());
        this.memberMergeMapper.mergeAddress(mainMember.getId(), subMember.getId());
        this.memberMergeMapper.mergeOrder(mainMember.getCode(), subMember.getCode());
        this.memberMergeMapper.mergePoint(mainMember.getCode(), subMember.getCode());
        this.logger.info("\u4f1a\u5458id:{} \u5408\u5e76 \u4f1a\u5458id:{} \u5b8c\u6210", (Object)mainMember.getId(), (Object)subMember.getId());
    }

    private void afterMerge(Member mainMember, Member subMember) {
        BigDecimal sum = this.memberEntityMapper.findTotalConsumptionAmountByCodeAndExpiredTime(mainMember.getCode(), DateUtil.format((Date)DateUtil.getNow(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (sum.compareTo(MemberLevel.VIP4.getLevelAmountCondition()) >= 0) {
            if (mainMember.getMemberLevel().compareTo(MemberLevel.VIP4.getId()) < 0) {
                mainMember.setMemberLevel(MemberLevel.VIP4.getId());
                mainMember.setLastLevelUpdateTime(DateUtil.getNow());
                mainMember.setLastLevelUpdateConsumption(sum);
                this.memberService.update(mainMember);
            }
        } else if (sum.compareTo(MemberLevel.VIP3.getLevelAmountCondition()) >= 0) {
            mainMember.setMemberLevel(MemberLevel.VIP3.getId());
            mainMember.setLastLevelUpdateTime(DateUtil.getNow());
            mainMember.setLastLevelUpdateConsumption(sum);
            this.memberService.update(mainMember);
        } else if (sum.compareTo(MemberLevel.VIP2.getLevelAmountCondition()) >= 0) {
            mainMember.setMemberLevel(MemberLevel.VIP2.getId());
            mainMember.setLastLevelUpdateTime(DateUtil.getNow());
            mainMember.setLastLevelUpdateConsumption(sum);
            this.memberService.update(mainMember);
        } else if (sum.compareTo(MemberLevel.VIP.getLevelAmountCondition()) >= 0) {
            mainMember.setMemberLevel(MemberLevel.VIP.getId());
            mainMember.setLastLevelUpdateTime(DateUtil.getNow());
            mainMember.setLastLevelUpdateConsumption(sum);
            this.memberService.update(mainMember);
        }
        this.logger.info("\u4f1a\u5458id:{} \u91cd\u65b0\u8ba1\u7b97\u4f1a\u5458\u7b49\u7ea7 \u5b8c\u6210", (Object)mainMember.getId());
    }

    @Override
    @Transactional
    public void doMemberMerge(Long mainMemberId, String verifiedMobile, LoginType loginType) {
        MergeStragetyContext context = new MergeStragetyContext(mainMemberId, verifiedMobile, loginType);
        context.doMerge();
    }

    private class MergeStragetyQQ
    extends AbstractMergeStragety {
        private MergeStragetyQQ() {
        }

        @Override
        public void doMerge(MergeStragetyContext context) {
            MemberMergeLogic.this.logger.info("qq\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5f00\u59cb", (Object)context.toString());
            Member mainMember = MemberMergeLogic.this.memberService.check(context.mainMemberId);
            List<MemberLogin> mainMemberLogins = MemberMergeLogic.this.memberLoginService.getByMemberId(context.mainMemberId);
            MemberLogin currLogin = null;
            for (MemberLogin mainMemberLogin : mainMemberLogins) {
                if (!mainMemberLogin.getLoginType().equals((Object)context.loginType.getId())) continue;
                currLogin = mainMemberLogin;
            }
            if (currLogin == null) {
                throw new UnknownException("\u5339\u914d\u4e0d\u5230\u7528\u6237\u7684" + context.loginType.getName() + "\u767b\u9646\u65b9\u5f0f");
            }
            HashSet<Long> subMemberIds = new HashSet<Long>();
            MemberLoginEntityExample loginExample = new MemberLoginEntityExample();
            MemberLoginEntityExample.Criteria loginCriteria = loginExample.createCriteria();
            loginCriteria.andMemberIdNotEqualTo(context.mainMemberId);
            loginCriteria.andLoginTypeEqualTo(LoginType.MOBILE.getId());
            loginCriteria.andLoginIdEqualTo(context.verifiedMobile);
            List<MemberLoginEntity> memberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
            if (CollectionUtils.isNotEmpty(memberLoginEntitys)) {
                for (MemberLoginEntity memberLoginEntity : memberLoginEntitys) {
                    Member otherMember = MemberMergeLogic.this.memberService.check(memberLoginEntity.getMemberId());
                    loginExample = new MemberLoginEntityExample();
                    loginCriteria = loginExample.createCriteria();
                    loginCriteria.andMemberIdEqualTo(otherMember.getId());
                    loginCriteria.andLoginTypeEqualTo(LoginType.QQ.getId());
                    List<MemberLoginEntity> otherMemberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
                    if (CollectionUtils.isNotEmpty(otherMemberLoginEntitys)) {
                        throw new UnknownException("\u5176\u4ed6\u4f1a\u5458\u62e5\u6709\u8be5\u624b\u673a\u53f7\u7801[" + context.verifiedMobile + "]\u7684\u767b\u9646\u65b9\u5f0f");
                    }
                    subMemberIds.add(otherMember.getId());
                }
            }
            for (Long subMemberId : subMemberIds) {
                MemberMergeLogic.this.mergeMember(context.mainMemberId, subMemberId);
            }
            MemberMergeLogic.this.logger.info("qq\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5b8c\u6210", (Object)context.toString());
        }
    }

    private class MergeStragetyWeibo
    extends AbstractMergeStragety {
        private MergeStragetyWeibo() {
        }

        @Override
        public void doMerge(MergeStragetyContext context) {
            MemberMergeLogic.this.logger.info("weibo\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5f00\u59cb", (Object)context.toString());
            Member mainMember = MemberMergeLogic.this.memberService.check(context.mainMemberId);
            List<MemberLogin> mainMemberLogins = MemberMergeLogic.this.memberLoginService.getByMemberId(context.mainMemberId);
            MemberLogin currLogin = null;
            for (MemberLogin mainMemberLogin : mainMemberLogins) {
                if (!mainMemberLogin.getLoginType().equals((Object)context.loginType.getId())) continue;
                currLogin = mainMemberLogin;
            }
            if (currLogin == null) {
                throw new UnknownException("\u5339\u914d\u4e0d\u5230\u7528\u6237\u7684" + context.loginType.getName() + "\u767b\u9646\u65b9\u5f0f");
            }
            HashSet<Long> subMemberIds = new HashSet<Long>();
            MemberLoginEntityExample loginExample = new MemberLoginEntityExample();
            MemberLoginEntityExample.Criteria loginCriteria = loginExample.createCriteria();
            loginCriteria.andMemberIdNotEqualTo(context.mainMemberId);
            loginCriteria.andLoginTypeEqualTo(LoginType.MOBILE.getId());
            loginCriteria.andLoginIdEqualTo(context.verifiedMobile);
            List<MemberLoginEntity> memberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
            if (CollectionUtils.isNotEmpty(memberLoginEntitys)) {
                for (MemberLoginEntity memberLoginEntity : memberLoginEntitys) {
                    Member otherMember = MemberMergeLogic.this.memberService.check(memberLoginEntity.getMemberId());
                    loginExample = new MemberLoginEntityExample();
                    loginCriteria = loginExample.createCriteria();
                    loginCriteria.andMemberIdEqualTo(otherMember.getId());
                    loginCriteria.andLoginTypeEqualTo(LoginType.WEIBO.getId());
                    List<MemberLoginEntity> otherMemberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
                    if (CollectionUtils.isNotEmpty(otherMemberLoginEntitys)) {
                        throw new UnknownException("\u5176\u4ed6\u4f1a\u5458\u62e5\u6709\u8be5\u624b\u673a\u53f7\u7801[" + context.verifiedMobile + "]\u7684\u767b\u9646\u65b9\u5f0f");
                    }
                    subMemberIds.add(otherMember.getId());
                }
            }
            for (Long subMemberId : subMemberIds) {
                MemberMergeLogic.this.mergeMember(context.mainMemberId, subMemberId);
            }
            MemberMergeLogic.this.logger.info("weibo\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5b8c\u6210", (Object)context.toString());
        }
    }

    private class MergeStragetyWeixin
    extends AbstractMergeStragety {
        private MergeStragetyWeixin() {
        }

        @Override
        public void doMerge(MergeStragetyContext context) {
            MemberMergeLogic.this.logger.info("weixin\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5f00\u59cb", (Object)context.toString());
            Member mainMember = MemberMergeLogic.this.memberService.check(context.mainMemberId);
            List<MemberLogin> mainMemberLogins = MemberMergeLogic.this.memberLoginService.getByMemberId(context.mainMemberId);
            MemberLogin currLogin = null;
            for (MemberLogin mainMemberLogin : mainMemberLogins) {
                if (!mainMemberLogin.getLoginType().equals((Object)context.loginType.getId())) continue;
                currLogin = mainMemberLogin;
                break;
            }
            if (currLogin == null) {
                throw new UnknownException("\u5339\u914d\u4e0d\u5230\u7528\u6237\u7684" + context.loginType.getName() + "\u767b\u9646\u65b9\u5f0f");
            }
            HashSet<Long> subMemberIds = new HashSet<Long>();
            MemberLoginEntityExample loginExample = new MemberLoginEntityExample();
            MemberLoginEntityExample.Criteria loginCriteria = loginExample.createCriteria();
            loginCriteria.andMemberIdNotEqualTo(context.mainMemberId);
            loginCriteria.andLoginTypeEqualTo(LoginType.MOBILE.getId());
            loginCriteria.andLoginIdEqualTo(context.verifiedMobile);
            List<MemberLoginEntity> memberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
            if (CollectionUtils.isNotEmpty(memberLoginEntitys)) {
                if (currLogin.getUnionId() == null) {
                    throw new UnknownException("\u5176\u4ed6\u4f1a\u5458\u62e5\u6709\u8be5\u624b\u673a\u53f7\u7801[" + context.verifiedMobile + "]\u7684\u767b\u9646\u65b9\u5f0f");
                }
                for (MemberLoginEntity memberLoginEntity : memberLoginEntitys) {
                    Member otherMember = MemberMergeLogic.this.memberService.check(memberLoginEntity.getMemberId());
                    loginExample = new MemberLoginEntityExample();
                    loginCriteria = loginExample.createCriteria();
                    loginCriteria.andMemberIdEqualTo(otherMember.getId());
                    loginCriteria.andLoginTypeEqualTo(LoginType.WEIXIN.getId());
                    loginCriteria.andUnionIdNotEqualTo(currLogin.getUnionId());
                    List<MemberLoginEntity> otherMemberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
                    if (CollectionUtils.isNotEmpty(otherMemberLoginEntitys)) {
                        throw new UnknownException("\u5176\u4ed6\u4f1a\u5458\u62e5\u6709\u8be5\u624b\u673a\u53f7\u7801[" + context.verifiedMobile + "]\u7684\u767b\u9646\u65b9\u5f0f");
                    }
                    subMemberIds.add(otherMember.getId());
                }
            }
            if (currLogin.getUnionId() != null) {
                loginExample = new MemberLoginEntityExample();
                loginCriteria = loginExample.createCriteria();
                loginCriteria.andMemberIdNotEqualTo(context.mainMemberId);
                loginCriteria.andLoginTypeEqualTo(LoginType.WEIXIN.getId());
                loginCriteria.andUnionIdEqualTo(currLogin.getUnionId());
                List<MemberLoginEntity> sameUnionMemberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
                for (MemberLoginEntity sameUnionMemberLoginEntity : sameUnionMemberLoginEntitys) {
                    subMemberIds.add(sameUnionMemberLoginEntity.getId());
                }
            }
            for (Long subMemberId : subMemberIds) {
                MemberMergeLogic.this.mergeMember(context.mainMemberId, subMemberId);
            }
            MemberMergeLogic.this.logger.info("weixin\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5b8c\u6210", (Object)context.toString());
        }
    }

    private class MergeStragetyMobile
    extends AbstractMergeStragety {
        private MergeStragetyMobile() {
        }

        @Override
        public void doMerge(MergeStragetyContext context) {
            MemberMergeLogic.this.logger.info("mobile\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5f00\u59cb", (Object)context.toString());
            Member mainMember = MemberMergeLogic.this.memberService.check(context.mainMemberId);
            List<MemberLogin> mainMemberLogins = MemberMergeLogic.this.memberLoginService.getByMemberId(context.mainMemberId);
            MemberLogin currLogin = null;
            for (MemberLogin mainMemberLogin : mainMemberLogins) {
                if (!mainMemberLogin.getLoginType().equals((Object)context.loginType.getId())) continue;
                currLogin = mainMemberLogin;
            }
            if (currLogin == null) {
                throw new UnknownException("\u5339\u914d\u4e0d\u5230\u7528\u6237\u7684" + context.loginType.getName() + "\u767b\u9646\u65b9\u5f0f");
            }
            HashSet<Long> subMemberIds = new HashSet<Long>();
            MemberLoginEntityExample loginExample = new MemberLoginEntityExample();
            MemberLoginEntityExample.Criteria loginCriteria = loginExample.createCriteria();
            loginCriteria.andMemberIdNotEqualTo(context.mainMemberId);
            loginCriteria.andLoginTypeEqualTo(LoginType.MOBILE.getId());
            loginCriteria.andLoginIdEqualTo(context.verifiedMobile);
            List<MemberLoginEntity> memberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
            if (CollectionUtils.isNotEmpty(memberLoginEntitys)) {
                for (MemberLoginEntity memberLoginEntity : memberLoginEntitys) {
                    Member otherMember = MemberMergeLogic.this.memberService.check(memberLoginEntity.getMemberId());
                    loginExample = new MemberLoginEntityExample();
                    loginCriteria = loginExample.createCriteria();
                    loginCriteria.andMemberIdEqualTo(otherMember.getId());
                    loginCriteria.andLoginTypeEqualTo(LoginType.MOBILE.getId());
                    List<MemberLoginEntity> otherMemberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
                    if (CollectionUtils.isNotEmpty(otherMemberLoginEntitys)) {
                        throw new UnknownException("\u5176\u4ed6\u4f1a\u5458\u62e5\u6709\u8be5\u624b\u673a\u53f7\u7801[" + context.verifiedMobile + "]\u7684\u767b\u9646\u65b9\u5f0f");
                    }
                    subMemberIds.add(otherMember.getId());
                }
            }
            for (Long subMemberId : subMemberIds) {
                MemberMergeLogic.this.mergeMember(context.mainMemberId, subMemberId);
            }
            MemberMergeLogic.this.logger.info("mobile\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5b8c\u6210", (Object)context.toString());
        }
    }

    private class MergeStragetyEmail
    extends AbstractMergeStragety {
        private MergeStragetyEmail() {
        }

        @Override
        public void doMerge(MergeStragetyContext context) {
            MemberMergeLogic.this.logger.info("email\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5f00\u59cb", (Object)context.toString());
            Member mainMember = MemberMergeLogic.this.memberService.check(context.mainMemberId);
            List<MemberLogin> mainMemberLogins = MemberMergeLogic.this.memberLoginService.getByMemberId(context.mainMemberId);
            MemberLogin currLogin = null;
            for (MemberLogin mainMemberLogin : mainMemberLogins) {
                if (!mainMemberLogin.getLoginType().equals((Object)context.loginType.getId())) continue;
                currLogin = mainMemberLogin;
            }
            if (currLogin == null) {
                throw new UnknownException("\u5339\u914d\u4e0d\u5230\u7528\u6237\u7684" + context.loginType.getName() + "\u767b\u9646\u65b9\u5f0f");
            }
            HashSet<Long> subMemberIds = new HashSet<Long>();
            MemberLoginEntityExample loginExample = new MemberLoginEntityExample();
            MemberLoginEntityExample.Criteria loginCriteria = loginExample.createCriteria();
            loginCriteria.andMemberIdNotEqualTo(context.mainMemberId);
            loginCriteria.andLoginTypeEqualTo(LoginType.MOBILE.getId());
            loginCriteria.andLoginIdEqualTo(context.verifiedMobile);
            List<MemberLoginEntity> memberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
            if (CollectionUtils.isNotEmpty(memberLoginEntitys)) {
                for (MemberLoginEntity memberLoginEntity : memberLoginEntitys) {
                    Member otherMember = MemberMergeLogic.this.memberService.check(memberLoginEntity.getMemberId());
                    loginExample = new MemberLoginEntityExample();
                    loginCriteria = loginExample.createCriteria();
                    loginCriteria.andMemberIdEqualTo(otherMember.getId());
                    loginCriteria.andLoginTypeEqualTo(LoginType.EMAIL.getId());
                    List<MemberLoginEntity> otherMemberLoginEntitys = MemberMergeLogic.this.memberLoginEntityMapper.selectByExample(loginExample);
                    if (CollectionUtils.isNotEmpty(otherMemberLoginEntitys)) {
                        throw new UnknownException("\u5176\u4ed6\u4f1a\u5458\u62e5\u6709\u8be5\u624b\u673a\u53f7\u7801[" + context.verifiedMobile + "]\u7684\u767b\u9646\u65b9\u5f0f");
                    }
                    subMemberIds.add(otherMember.getId());
                }
            }
            for (Long subMemberId : subMemberIds) {
                MemberMergeLogic.this.mergeMember(context.mainMemberId, subMemberId);
            }
            MemberMergeLogic.this.logger.info("email\u767b\u9646\u65b9\u5f0f\u7684\u5408\u5e76:{} \u5b8c\u6210", (Object)context.toString());
        }
    }

    private abstract class AbstractMergeStragety {
        private AbstractMergeStragety() {
        }

        public abstract void doMerge(MergeStragetyContext var1);
    }

    private class MergeStragetyContext {
        private AbstractMergeStragety strategy;
        private Long mainMemberId;
        private String verifiedMobile;
        private LoginType loginType;

        public MergeStragetyContext(Long mainMemberId, String verifiedMobile, LoginType loginType) {
            this.mainMemberId = mainMemberId;
            this.verifiedMobile = verifiedMobile;
            this.loginType = loginType;
            if (loginType.equals((Object)LoginType.EMAIL)) {
                this.strategy = new MergeStragetyEmail();
            } else if (loginType.equals((Object)LoginType.MOBILE)) {
                this.strategy = new MergeStragetyMobile();
            } else if (loginType.equals((Object)LoginType.WEIXIN)) {
                this.strategy = new MergeStragetyWeixin();
            } else if (loginType.equals((Object)LoginType.WEIBO)) {
                this.strategy = new MergeStragetyWeibo();
            } else if (loginType.equals((Object)LoginType.QQ)) {
                this.strategy = new MergeStragetyQQ();
            } else {
                throw new UnknownException("\u5339\u914d\u4e0d\u5230\u5408\u5e76\u7b56\u7565");
            }
        }

        public void doMerge() {
            this.strategy.doMerge(this);
        }

        public String toString() {
            return "MergeStragetyContext{mainMemberId=" + this.mainMemberId + ", verifiedMobile='" + this.verifiedMobile + '\'' + ", loginType=" + this.loginType + '}';
        }
    }
}

