/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member.service.business;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.component.coupon.condition.CouponCondition;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.pegasus.component.coupon.service.CouponService;
import com.thebeastshop.pegasus.component.coupon.support.CouponServiceLoader;
import com.thebeastshop.pegasus.component.coupon.util.HttpKit;
import com.thebeastshop.pegasus.component.member.condition.MemberLoginHistoryCondition;
import com.thebeastshop.pegasus.component.member.constants.MemberConstant;
import com.thebeastshop.pegasus.component.member.domain.Member;
import com.thebeastshop.pegasus.component.member.domain.MemberLogin;
import com.thebeastshop.pegasus.component.member.domain.MemberLoginHistory;
import com.thebeastshop.pegasus.component.member.service.MemberLoginHistoryService;
import com.thebeastshop.pegasus.component.member.service.MemberLoginService;
import com.thebeastshop.pegasus.component.support.ConsJson;
import com.thebeastshop.pegasus.component.support.config.PropertyConfigurer;
import com.thebeastshop.pegasus.service.operation.ezrUtil.vo.UserInfo;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.enums.LoginType;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class MemberServiceAdvice {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MemberLoginHistoryService memberLoginHistoryService;
    @Autowired
    private MemberLoginService memberLoginService;
    @Autowired
    private PropertyConfigurer propertyConfigurer;
    private CouponSampleService couponSampleService = (CouponSampleService)CouponServiceLoader.getBean(CouponSampleService.class);
    private CouponService couponService = (CouponService)CouponServiceLoader.getBean(CouponService.class);

    @AfterReturning(value="execution(* com.thebeastshop.pegasus.component.member.*.memberLogin(..))", returning="member")
    public void loginAdvice(Member member) {
        this.logger.info("member:{}", (Object)member);
        try {
            if (member != null && member.getId() != null && !member.getId().equals(MemberConstant.DEFAULT_MEMBER_ID)) {
                Long memberId = member.getId();
                MemberLoginHistoryCondition condition = new MemberLoginHistoryCondition();
                condition.setMemberId(memberId);
                condition.setAccessWay(AccessWay.APP);
                List<MemberLoginHistory> historys = this.memberLoginHistoryService.findByCondition(condition);
                if (CollectionUtils.isNotEmpty(historys) && historys.size() <= 1) {
                    Long couponSampleId = MemberConstant.NEW_MEMBER_COUPON_ID;
                    this.logger.info("newMembercouponId:{}", (Object)couponSampleId);
                    CouponCondition couponCondition = new CouponCondition();
                    couponCondition.setOwnerId(memberId);
                    couponCondition.setCouponSampleId(couponSampleId);
                    List coupons = this.couponService.getCouponsByCondition(couponCondition);
                    if (CollectionUtils.isEmpty((Collection)coupons)) {
                        CouponSample couponSample = this.couponSampleService.getById(couponSampleId.longValue());
                        if (couponSample == null) {
                            this.logger.info("\u65b0\u4eba\u5238\u4e0d\u5b58\u5728:{}", (Object)couponSampleId);
                            return;
                        }
                        this.couponService.send(couponSample, memberId.longValue());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u4f1a\u5458\u767b\u9646\u901a\u77e5\u5f02\u5e38 e:{}", (Throwable)e);
        }
    }

    @AfterReturning(value="execution(* com.thebeastshop.pegasus.component.member..*.memberRegister(..))", returning="member")
    public void memberSynchronizedForEZR(Member member) {
        this.logger.info("member:{}", (Object)member);
        try {
            if (member != null && member.getId() != null && !member.getId().equals(MemberConstant.DEFAULT_MEMBER_ID)) {
                List<MemberLogin> logins = this.memberLoginService.getByMemberId(member.getId());
                this.logger.info("\u7ed9ezr\u540c\u6b65\u624b\u673a\u53f7\u4e3a" + member.getVerifiedMobile() + "\uff1a" + member.getNickName());
                UserInfo vo = this.convertMemberToUserInfo(member);
                ConsJson consJson = new ConsJson();
                HashMap<String, String> buildParams = new HashMap<String, String>();
                buildParams.put("Args", consJson.Object2Json(vo));
                String jsonObj = HttpKit.post((String)(this.propertyConfigurer.getEzrBaseUrl() + "/vip/openCardOffline"), buildParams, (String)"");
                JSONObject res = JSONObject.parseObject((String)jsonObj);
                if (res.getBoolean("Status").booleanValue()) {
                    this.logger.info("ezr\u540c\u6b65\u6ce8\u518c\u6210\u529f");
                } else {
                    this.logger.info("ezr\u540c\u6b65\u6ce8\u518c\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            this.logger.info("\u4f1a\u5458\u540c\u6b65\u5f02\u5e38\u901a\u77e5 e:{}", (Throwable)e);
        }
    }

    private UserInfo convertMemberToUserInfo(Member member) {
        List<MemberLogin> logins = this.memberLoginService.getByMemberId(member.getId());
        UserInfo vo = new UserInfo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        vo.setCode(member.getCode());
        vo.setRegShop("CHN2049");
        vo.setOldCode(member.getCode());
        vo.setNickName(member.getNickName());
        vo.setMobileNo(member.getVerifiedMobile());
        if (member.getGender() == 3) {
            vo.setSex("0");
        } else {
            vo.setSex(member.getGender().toString());
        }
        int bigLevel = 0;
        bigLevel = member.getStartupLevel() >= member.getMemberLevel() ? member.getStartupLevel().intValue() : member.getMemberLevel().intValue();
        if (bigLevel == -1) {
            vo.setGrade("\u6ce8\u518c\u7528\u6237");
        } else if (bigLevel == 0) {
            vo.setGrade("\u677e\u9f20\u4f1a\u5458");
        } else if (bigLevel == 1) {
            vo.setGrade("\u5c0f\u732b\u4f1a\u5458");
        } else if (bigLevel == 2) {
            vo.setGrade("\u8001\u864e\u4f1a\u5458 ");
        } else if (bigLevel == 3) {
            vo.setGrade("\u5927\u8c61\u4f1a\u5458");
        }
        if (member.getBirthday() != null) {
            vo.setBirthday(sdf.format(member.getBirthday()));
        }
        for (MemberLogin memberLogin : logins) {
            if (memberLogin.getLoginType().equals((Object)LoginType.WEIXIN)) {
                vo.setWxNo(memberLogin.getLoginId());
                vo.setWxUnionId(memberLogin.getUnionId());
                continue;
            }
            if (memberLogin.getLoginType().equals((Object)LoginType.QQ)) {
                vo.setQqNo(memberLogin.getLoginId());
                continue;
            }
            if (!memberLogin.getLoginType().equals((Object)LoginType.WEIBO)) continue;
            vo.setWeibNo(memberLogin.getLoginId());
        }
        vo.setEmail(member.getEmail());
        vo.setRegShop("CHN2049");
        if (member.getRegisterTime() != null) {
            vo.setRegDate(sdf2.format(member.getRegisterTime()));
        }
        return vo;
    }
}

