/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member.domain;

import com.thebeastshop.pegasus.component.member.enums.Gender;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.enums.Title;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.util.EnumUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Member {
    private Long id;
    private String code;
    private Integer memberStatus;
    private String mergeTo;
    private Integer memberLevel;
    private Integer startupLevel;
    private String memberLevelDesc;
    private String nickName = "";
    private Integer gender;
    private String phone;
    private String mobile;
    private String email;
    private Integer registerSource;
    private Date registerTime;
    private String remark;
    private Date birthday;
    private String province;
    private String city;
    private String district;
    private Integer title;
    private String titleDesc;
    private String avatarUrl;
    private String accountWechat;
    private String accountWeibo;
    private String job;
    private Integer constellation;
    private Integer degree;
    private String address;
    private String zipCode;
    private Integer memberType;
    private BigDecimal point;
    private Double historyPoint;
    private String verifiedMobile;
    private Date lastLoginTime;
    private Date lastLevelUpdateTime;
    private BigDecimal lastLevelUpdateConsumption;
    private String mobileCode;
    private Integer birthdayDiscountYear;
    private String downloadSource;
    private String channelCode;

    public Member() {
        this.gender = Gender.SECRET.code;
    }

    public Integer getBirthdayDiscountYear() {
        return this.birthdayDiscountYear;
    }

    public void setBirthdayDiscountYear(Integer birthdayDiscountYear) {
        this.birthdayDiscountYear = birthdayDiscountYear;
    }

    public String getAccountWechat() {
        return this.accountWechat;
    }

    public String getAccountWeibo() {
        return this.accountWeibo;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public String getCity() {
        return this.city;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getConstellation() {
        return this.constellation;
    }

    public Integer getDegree() {
        return this.degree;
    }

    public String getDistrict() {
        return this.district;
    }

    public String getEmail() {
        return this.email;
    }

    public Integer getGender() {
        return this.gender;
    }

    public Long getId() {
        return this.id;
    }

    public String getJob() {
        return this.job;
    }

    public Integer getMemberLevel() {
        return this.memberLevel;
    }

    public Integer getMemberStatus() {
        return this.memberStatus;
    }

    public Integer getStartupLevel() {
        return this.startupLevel;
    }

    public void setStartupLevel(Integer startupLevel) {
        this.startupLevel = startupLevel;
    }

    public Integer getMemberType() {
        return this.memberType;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getProvince() {
        return this.province;
    }

    public Integer getRegisterSource() {
        return this.registerSource;
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getTitle() {
        return this.title;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setAccountWechat(String accountWechat) {
        this.accountWechat = accountWechat;
    }

    public void setAccountWeibo(String accountWeibo) {
        this.accountWeibo = accountWeibo;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setConstellation(Integer constellation) {
        this.constellation = constellation;
    }

    public void setDegree(Integer degree) {
        this.degree = degree;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public void setMemberLevel(Integer memberLevel) {
        this.memberLevel = memberLevel;
    }

    public void setMemberStatus(Integer memberStatus) {
        this.memberStatus = memberStatus;
    }

    public void setMemberType(Integer memberType) {
        this.memberType = memberType;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setRegisterSource(Integer registerSource) {
        this.registerSource = registerSource;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setTitle(Integer title) {
        this.title = title;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public BigDecimal getPoint() {
        return this.point;
    }

    public void setPoint(BigDecimal point) {
        this.point = point;
    }

    public Double getHistoryPoint() {
        return this.historyPoint;
    }

    public void setHistoryPoint(Double historyPoint) {
        this.historyPoint = historyPoint;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getMemberLevelDesc() {
        if (this.memberLevel == MemberLevel.NORMAL.getId()) {
            this.memberLevelDesc = MemberLevel.NORMAL.getName();
        } else if (this.memberLevel == MemberLevel.VIP.getId()) {
            this.memberLevelDesc = MemberLevel.VIP.getName();
        } else if (this.memberLevel == MemberLevel.VIP2.getId()) {
            this.memberLevelDesc = MemberLevel.VIP2.getName();
        } else if (this.memberLevel == MemberLevel.VIP3.getId()) {
            this.memberLevelDesc = MemberLevel.VIP3.getName();
        } else if (this.memberLevel == MemberLevel.VIP4.getId()) {
            this.memberLevelDesc = MemberLevel.VIP4.getName();
        }
        return this.memberLevelDesc;
    }

    public void setMemberLevelDesc(String memberLevelDesc) {
        this.memberLevelDesc = memberLevelDesc;
    }

    public String getVerifiedMobile() {
        return this.verifiedMobile;
    }

    public void setVerifiedMobile(String verifiedMobile) {
        this.verifiedMobile = verifiedMobile;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getTitleDesc() {
        if (this.title != null) {
            if (this.title.equals(Title.MS.getId())) {
                this.titleDesc = Title.MS.getName();
            } else if (this.title.equals(Title.MISS.getId())) {
                this.titleDesc = Title.MISS.getName();
            } else if (this.title.equals(Title.MR.getId())) {
                this.titleDesc = Title.MR.getName();
            } else if (this.title.equals(Title.UNKNOWN.getId())) {
                this.titleDesc = Title.UNKNOWN.getName();
            }
        } else {
            this.titleDesc = Title.UNKNOWN.getName();
        }
        return this.titleDesc;
    }

    public void setTitleDesc(String titleDesc) {
        this.titleDesc = titleDesc;
    }

    public String getMergeTo() {
        return this.mergeTo;
    }

    public void setMergeTo(String mergeTo) {
        this.mergeTo = mergeTo;
    }

    public Date getLastLevelUpdateTime() {
        return this.lastLevelUpdateTime;
    }

    public void setLastLevelUpdateTime(Date lastLevelUpdateTime) {
        this.lastLevelUpdateTime = lastLevelUpdateTime;
    }

    public BigDecimal getLastLevelUpdateConsumption() {
        return this.lastLevelUpdateConsumption;
    }

    public void setLastLevelUpdateConsumption(BigDecimal lastLevelUpdateConsumption) {
        this.lastLevelUpdateConsumption = lastLevelUpdateConsumption;
    }

    public String getMobileCode() {
        return this.mobileCode;
    }

    public void setMobileCode(String mobileCode) {
        this.mobileCode = mobileCode;
    }

    public String getDownloadSource() {
        return this.downloadSource;
    }

    public void setDownloadSource(String downloadSource) {
        this.downloadSource = downloadSource;
    }

    public boolean isInBdayDiscountTime() {
        MemberLevel level;
        boolean rt = false;
        if (this.getBirthday() != null && this.getMemberLevel() != null && !(level = (MemberLevel)EnumUtil.valueOf((Comparable)this.getMemberLevel(), MemberLevel.class)).equals((Object)MemberLevel.NORMAL)) {
            try {
                if (!this.isBdayDiscountUsed()) {
                    Calendar now = Calendar.getInstance();
                    int year = now.get(1);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    String birthday = df.format(this.getBirthday());
                    String dateStr = year + birthday.substring(4, birthday.length());
                    Calendar birthDay = Calendar.getInstance();
                    birthDay.setTime(df.parse(dateStr));
                    int day1 = now.get(6);
                    int day2 = birthDay.get(6);
                    int days = day1 - day2 + 1;
                    int useday = 0;
                    switch (level) {
                        case VIP: {
                            useday = 1;
                            break;
                        }
                        case VIP2: 
                        case VIP3: 
                        case VIP4: {
                            useday = 7;
                        }
                    }
                    if (days >= 0 && useday >= days) {
                        rt = true;
                    }
                }
            }
            catch (Exception e) {
                throw new UnknownException("\u5224\u65ad\u662f\u5426\u53ef\u7528\u751f\u65e5\u6298\u6263\u5f02\u5e38! e={}", (Throwable)e);
            }
        }
        return rt;
    }

    public boolean isBdayDiscountUsed() {
        boolean rt = false;
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        if (this.getBirthdayDiscountYear() != null && this.getBirthdayDiscountYear().equals(year)) {
            rt = true;
        }
        return rt;
    }

    public BigDecimal getBdayDiscountRatio() {
        BigDecimal discount = BigDecimal.valueOf(1L);
        if (this.getMemberLevel() != null) {
            MemberLevel memberLevel = (MemberLevel)EnumUtil.valueOf((Comparable)this.getMemberLevel(), MemberLevel.class);
            switch (memberLevel) {
                case VIP: {
                    discount = BigDecimal.valueOf(0.95);
                    break;
                }
                case VIP2: {
                    discount = BigDecimal.valueOf(0.948);
                    break;
                }
                case VIP3: {
                    discount = BigDecimal.valueOf(0.945);
                    break;
                }
                case VIP4: {
                    discount = BigDecimal.valueOf(0.889);
                }
            }
        }
        return discount;
    }

    public String toString() {
        return "Member [id=" + this.id + ", code=" + this.code + ", memberStatus=" + this.memberStatus + ", mergeTo=" + this.mergeTo + ", memberLevel=" + this.memberLevel + ", startupLevel=" + this.startupLevel + ", memberLevelDesc=" + this.memberLevelDesc + ", nickName=" + this.nickName + ", gender=" + this.gender + ", phone=" + this.phone + ", mobile=" + this.mobile + ", email=" + this.email + ", registerSource=" + this.registerSource + ", registerTime=" + this.registerTime + ", remark=" + this.remark + ", birthday=" + this.birthday + ", province=" + this.province + ", city=" + this.city + ", district=" + this.district + ", title=" + this.title + ", titleDesc=" + this.titleDesc + ", avatarUrl=" + this.avatarUrl + ", accountWechat=" + this.accountWechat + ", accountWeibo=" + this.accountWeibo + ", job=" + this.job + ", constellation=" + this.constellation + ", degree=" + this.degree + ", address=" + this.address + ", zipCode=" + this.zipCode + ", memberType=" + this.memberType + ", point=" + this.point + ", historyPoint=" + this.historyPoint + ", verifiedMobile=" + this.verifiedMobile + ", lastLoginTime=" + this.lastLoginTime + ", lastLevelUpdateTime=" + this.lastLevelUpdateTime + ", lastLevelUpdateConsumption=" + this.lastLevelUpdateConsumption + ", mobileCode=" + this.mobileCode + ", birthdayDiscountYear=" + this.birthdayDiscountYear + ", downloadSource=" + this.downloadSource + ",channelCode = " + this.channelCode + "]";
    }
}

