/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.member;

import com.thebeastshop.member.point.service.MemberPointRelevanceService;
import com.thebeastshop.pegasus.component.member.condition.MemberCondition;
import com.thebeastshop.pegasus.component.member.condition.MemberLoginCondition;
import com.thebeastshop.pegasus.component.member.constants.MemberConstant;
import com.thebeastshop.pegasus.component.member.domain.Feedback;
import com.thebeastshop.pegasus.component.member.domain.Member;
import com.thebeastshop.pegasus.component.member.domain.MemberAddress;
import com.thebeastshop.pegasus.component.member.domain.MemberLogin;
import com.thebeastshop.pegasus.component.member.domain.MemberLoginHistory;
import com.thebeastshop.pegasus.component.member.domain.MemberRegister;
import com.thebeastshop.pegasus.component.member.enums.ConstellationType;
import com.thebeastshop.pegasus.component.member.enums.DegreeType;
import com.thebeastshop.pegasus.component.member.service.FeedbackService;
import com.thebeastshop.pegasus.component.member.service.MemberAddressService;
import com.thebeastshop.pegasus.component.member.service.MemberLoginHistoryService;
import com.thebeastshop.pegasus.component.member.service.MemberLoginService;
import com.thebeastshop.pegasus.component.member.service.MemberService;
import com.thebeastshop.pegasus.component.member.service.business.IMemberMergeLogic;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.util.comm.BCrypt;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.support.enums.LoginType;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.enums.RegisterSource;
import com.thebeastshop.support.exception.BusinessLogicNotExpectedException;
import com.thebeastshop.support.exception.ForbiddenException;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.NameValuePair;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class PegasusMemberServiceFacade {
    private static final Logger logger = LoggerFactory.getLogger(PegasusMemberServiceFacade.class);
    private static final String channelCode = "CHN2049";
    private static PegasusMemberServiceFacade instance;
    @Autowired
    private MemberLoginService memberLoginService;
    @Autowired
    private MemberLoginHistoryService memberLoginHistoryService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberPointRelevanceService memberPointRelevanceService;
    @Autowired
    private MemberAddressService memberAddressService;
    @Autowired
    private FeedbackService feedbackService;
    @Autowired
    private IMemberMergeLogic memberMergeLogic;

    private List<MemberLogin> getMemberLogins(LoginType loginType, String loginId, String unionId) {
        MemberLoginCondition condition = new MemberLoginCondition();
        if (loginType.equals((Object)LoginType.WEIXIN)) {
            condition.setUnionId(unionId);
        } else {
            condition.setLoginId(loginId);
        }
        List<MemberLogin> memberLoginList = this.memberLoginService.findByCondition(condition);
        return memberLoginList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusMemberServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusFacadeLock> clazz = PegasusFacadeLock.class;
        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                instance = ComponentServiceLoader.getBean(PegasusMemberServiceFacade.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean updateMember(Member member) {
        return this.memberService.update(member);
    }

    public Member getMemberById(Long id) {
        return this.memberService.getById(id);
    }

    public List<MemberLogin> getMemLoginByMemId(Long id) {
        return this.memberLoginService.getByMemberId(id);
    }

    public List<MemberLogin> findMemLoginByCondition(MemberLoginCondition condition) {
        return this.memberLoginService.findByCondition(condition);
    }

    public boolean changeMemberPasswd(String mobile, String newPasswd) {
        MemberLoginCondition condition = new MemberLoginCondition();
        condition.setLoginId(mobile);
        List<MemberLogin> logins = this.memberLoginService.findByCondition(condition);
        if (CollectionUtils.isNotEmpty(logins)) {
            Long memberId = logins.get(0).getMemberId();
            List<MemberLogin> loginList = this.memberLoginService.getByMemberId(memberId);
            return this.changeMemberPasswd(loginList, newPasswd);
        }
        return false;
    }

    public boolean changeMemberPasswd(Long memberId, String oldPasswd, String newPasswd) {
        List<MemberLogin> list = this.memberLoginService.getByMemberId(memberId);
        if (CollectionUtils.isNotEmpty(list)) {
            MemberLogin memberLogin = list.get(0);
            if (memberLogin.getPasswd() != null && !BCrypt.checkpw((String)oldPasswd, (String)memberLogin.getPasswd())) {
                throw new WrongArgException("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e", new NameValuePair[0]);
            }
            return this.changeMemberPasswd(list, newPasswd);
        }
        return false;
    }

    @Transactional
    public boolean changeMemberPasswd(List<MemberLogin> list, String newPasswd) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (MemberLogin login : list) {
                login.setPasswd(BCrypt.hashpw((String)newPasswd));
                if (this.memberLoginService.update(login)) continue;
                throw new UnknownException("\u4fee\u6539\u5bc6\u7801\u5f02\u5e38");
            }
            return true;
        }
        return false;
    }

    public Member memberLogin(MemberLogin login, MemberLoginHistory loginHistroy) {
        Member member = null;
        MemberLogin memberLogin = null;
        List<MemberLogin> memberLoginList = this.getMemberLogins(login.getLoginType(), login.getLoginId(), login.getUnionId());
        if (CollectionUtils.isNotEmpty(memberLoginList)) {
            memberLogin = memberLoginList.get(0);
        }
        switch (login.getLoginType()) {
            case EMAIL: 
            case MOBILE: {
                if (memberLogin != null) {
                    if (BCrypt.checkpw((String)login.getPasswd(), (String)memberLogin.getPasswd())) break;
                    throw new WrongArgException("\u5bc6\u7801\u4e0d\u6b63\u786e", new NameValuePair[0]);
                }
                logger.info("user login failed: name or password wrong");
                throw new WrongArgException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728", new NameValuePair[0]);
            }
        }
        if (memberLogin != null) {
            member = this.memberService.getById(memberLogin.getMemberId());
            if (member != null && !member.getMemberStatus().equals(1)) {
                throw new ForbiddenException("\u7528\u6237\u88ab\u7981\u7528");
            }
            loginHistroy.setMemberId(member.getId());
            loginHistroy.setMemberLoginId(memberLogin.getId());
            this.memberLoginHistoryService.create(loginHistroy);
        }
        return member;
    }

    @Transactional
    public Member memberRegister(MemberRegister register) {
        Member member = null;
        List<MemberLogin> memberLoginList = this.getMemberLogins(register.getLoginType(), register.getLoginId(), register.getUnionId());
        if (CollectionUtils.isNotEmpty(memberLoginList)) {
            throw new WrongArgException("\u4f1a\u5458\u5df2\u5b58\u5728", new NameValuePair[0]);
        }
        if (register.getLoginType().equals((Object)LoginType.MOBILE)) {
            MemberCondition condition = new MemberCondition();
            condition.setVerifiedMobile(register.getLoginId().toString());
            List<Member> list = this.memberService.findByCondition(condition);
            if (CollectionUtils.isNotEmpty(list) && !list.get(0).getId().equals(MemberConstant.DEFAULT_MEMBER_ID)) {
                member = list.get(0);
                this.createMemberLogin(register, member);
            } else {
                member = this.createMember(register.getRegisterSource(), register.getLoginId(), register.getMobileCode(), "", register.getDownloadSource());
                this.createMemberLogin(register, member);
            }
        } else {
            member = this.createTempMember();
        }
        if (member == null) {
            throw new UnknownException("\u6ce8\u518c\u4f1a\u5458\u5931\u8d25");
        }
        return member;
    }

    @Transactional
    public Member bindMobile(Member member, String verifiedMobile) {
        if (member == null) {
            throw new UnknownException("\u7ed1\u5b9a\u624b\u673a\u53f7\u5f02\u5e38: member is null");
        }
        member.setVerifiedMobile(verifiedMobile);
        if (!this.memberService.update(member)) {
            throw new UnknownException("\u7ed1\u5b9a\u624b\u673a\u5931\u8d25\uff0c\u66f4\u65b0\u4f1a\u5458\u4fe1\u606f\u5f02\u5e38");
        }
        return member;
    }

    @Transactional
    public Member memLoginBindMember(MemberLogin login, Member member) {
        if (login != null && member != null && !member.getId().equals(MemberConstant.DEFAULT_MEMBER_ID)) {
            if (login.getId() == null) {
                MemberLoginCondition condition = new MemberLoginCondition();
                condition.setLoginId(login.getLoginId());
                List<MemberLogin> memberLoginList = this.memberLoginService.findByCondition(condition);
                if (CollectionUtils.isNotEmpty(memberLoginList)) {
                    login = memberLoginList.get(0);
                } else {
                    login.setMemberId(member.getId());
                    login = this.memberLoginService.create(login);
                }
            }
            login.setMemberId(member.getId());
            this.memberLoginService.update(login);
        }
        return member;
    }

    @Transactional
    public Member verifiedMobile(Long memberId, MemberLogin login, String mobileCode, String verifiedMobile, String password, String nickName, String downloadSource) {
        Member member = null;
        MemberLogin mobileLogin = null;
        MemberLoginCondition condition = new MemberLoginCondition();
        condition.setLoginType(LoginType.MOBILE);
        condition.setLoginId(verifiedMobile);
        List<MemberLogin> memberLoginList = this.memberLoginService.findByCondition(condition);
        if (CollectionUtils.isNotEmpty(memberLoginList)) {
            mobileLogin = memberLoginList.get(0);
        }
        if (memberId.equals(MemberConstant.DEFAULT_MEMBER_ID)) {
            if (login == null) {
                throw new WrongArgException("\u7b2c\u4e09\u65b9\u7ed1\u5b9a\u624b\u673a\u53f7,\u7b2c\u4e09\u65b9\u767b\u5f55\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!", new NameValuePair[0]);
            }
            if (mobileLogin != null && !mobileLogin.getMemberId().equals(MemberConstant.DEFAULT_MEMBER_ID)) {
                member = this.getMemberById(mobileLogin.getMemberId());
                this.memLoginBindMember(login, member);
            } else {
                LoginType loginType = login.getLoginType();
                RegisterSource registerSource = RegisterSource.APP;
                switch (loginType) {
                    case QQ: {
                        registerSource = RegisterSource.QQ;
                        break;
                    }
                    case WEIBO: {
                        registerSource = RegisterSource.WEIBO;
                        break;
                    }
                    case WEIXIN: {
                        registerSource = RegisterSource.WEIXIN;
                        break;
                    }
                    default: {
                        throw new WrongArgException("\u7b2c\u4e09\u65b9\u7ed1\u5b9a\u624b\u673a\u53f7,\u7b2c\u4e09\u65b9\u767b\u5f55\u65b9\u5f0f\u4e0d\u652f\u6301!", new NameValuePair[0]);
                    }
                }
                member = this.createMember(registerSource, verifiedMobile, mobileCode, nickName, downloadSource);
                this.memLoginBindMember(login, member);
            }
        } else {
            member = this.getMemberById(memberId);
        }
        if (mobileLogin == null) {
            MemberRegister register = new MemberRegister();
            register.setLoginId(verifiedMobile);
            register.setLoginType(LoginType.MOBILE);
            register.setPassword(password);
            register.setRegisterSource(RegisterSource.APP);
            register.setMobileCode(mobileCode);
            mobileLogin = this.createMemberLogin(register, member);
            member = this.memLoginBindMember(mobileLogin, member);
        }
        return this.bindMobile(member, verifiedMobile);
    }

    public MemberAddress addAddress(MemberAddress address) {
        return this.memberAddressService.create(address);
    }

    public boolean updateAddress(MemberAddress address) {
        return this.memberAddressService.update(address);
    }

    public boolean deleteAddress(Long id) {
        return this.memberAddressService.delete(id);
    }

    public MemberAddress getAddressById(Long id) {
        return this.memberAddressService.getById(id);
    }

    public List<MemberAddress> listAddress(Long memberId) {
        return this.memberAddressService.list(memberId);
    }

    public Feedback createFeedback(Feedback feedback) {
        return this.feedbackService.create(feedback);
    }

    public boolean updateFeedback(Feedback feedback) {
        return this.feedbackService.update(feedback);
    }

    public boolean deleteFeedback(Long id) {
        return this.feedbackService.delete(id);
    }

    public Feedback getFeedbackById(Long id) {
        return this.feedbackService.getById(id);
    }

    private String getUserCode(Map<String, Object> params) {
        return CodeGenerator.getInstance().generate("OP_MEMBER", params);
    }

    private MemberLogin createMemberLogin(MemberRegister register, Member member) {
        MemberLogin memberLogin = new MemberLogin();
        memberLogin.setLoginId(register.getLoginId());
        memberLogin.setLoginType(register.getLoginType());
        memberLogin.setUnionId(register.getUnionId());
        memberLogin.setMemberId(member.getId());
        memberLogin.setMobileCode(register.getMobileCode());
        if (StringUtils.isNotBlank((String)register.getPassword())) {
            memberLogin.setPasswd(BCrypt.hashpw((String)register.getPassword()));
        }
        return this.memberLoginService.create(memberLogin);
    }

    private Member createTempMember() {
        Member member = new Member();
        member.setId(MemberConstant.DEFAULT_MEMBER_ID);
        member.setCode("\u9ed8\u8ba4\u4f1a\u5458");
        member.setMemberStatus(1);
        member.setMemberLevel(MemberLevel.NORMAL.getId());
        member.setStartupLevel(MemberLevel.NORMAL.getId());
        member.setRegisterTime(new Date());
        member.setLastLoginTime(new Date());
        member.setConstellation(ConstellationType.UNKNOWN.getId());
        member.setDegree(DegreeType.OTHER.getId());
        member.setChannelCode(channelCode);
        return member;
    }

    public Member createMember(RegisterSource registerSource, String verifiedMobile, String mobileCode, String nickName, String downloadSource) {
        Member member = new Member();
        member.setMemberStatus(1);
        member.setMemberLevel(MemberLevel.NORMAL.getId());
        member.setStartupLevel(MemberLevel.NORMAL.getId());
        member.setRegisterSource(registerSource.getId());
        member.setRegisterTime(new Date());
        member.setLastLoginTime(new Date());
        member.setConstellation(ConstellationType.UNKNOWN.getId());
        member.setDegree(DegreeType.OTHER.getId());
        member.setVerifiedMobile(verifiedMobile);
        member.setMobileCode(mobileCode);
        member.setNickName(nickName);
        member.setDownloadSource(downloadSource);
        member.setChannelCode(channelCode);
        member = this.memberService.create(member);
        if (member != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("registerSource", member.getRegisterSource());
            params.put("id", member.getId());
            String code = this.getUserCode(params);
            if (StringUtils.isNotBlank((String)code)) {
                member.setCode(code);
                this.memberService.update(member);
            }
        }
        try {
            this.memberPointRelevanceService.saveMemberPointRelevance(member.getCode(), member.getId());
        }
        catch (Exception e) {
            logger.error("saveMemberPointRelevance\u5f02\u5e38:{}", (Throwable)e);
        }
        return member;
    }

    @Transactional
    public boolean baseMemberMerge(Long mainMemberId, Long subMemberId) {
        return this.memberMergeLogic.mergeMember(mainMemberId, subMemberId);
    }

    @Transactional
    public boolean baseMemberMerge(Long mainMemberId, Set<Long> subMemberIds) {
        for (Long subMemberId : subMemberIds) {
            boolean tf = this.memberMergeLogic.mergeMember(mainMemberId, subMemberId);
            if (tf) continue;
            throw new BusinessLogicNotExpectedException("\u5408\u5e76\u7528\u6237\u51fa\u9519");
        }
        return true;
    }

    public MemberAddress getDefaultByMemberId(Long id) {
        return this.memberAddressService.getDefaultByOwnerId(id);
    }
}

