/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.file.service.impl;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.thebeastshop.pegasus.component.file.config.Config;
import com.thebeastshop.pegasus.component.file.domain.FileInfo;
import com.thebeastshop.pegasus.component.file.service.FileService;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.util.ByteUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
implements FileService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static OSSClient ossClient;

    private OSSClient getOssClient() {
        if (ossClient == null) {
            ossClient = new OSSClient(Config.OSS_END_POINT, Config.OSS_ACCESS_ID, Config.OSS_ACCESS_KEY);
        }
        return ossClient;
    }

    @Override
    public FileInfo uploadFile(String localFilePath, String extraPath) {
        File file = new File(localFilePath);
        return this.uploadFile(file, extraPath);
    }

    @Override
    public FileInfo uploadFile(File file, String extraPath) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25: {}", (Throwable)e);
            throw new UnknownException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
        return this.uploadFile(input, extraPath);
    }

    @Override
    public FileInfo uploadFile(InputStream inputStream, String extraPath) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            inputStream = new ByteArrayInputStream(baos.toByteArray());
            String key = "";
            byte[] b = Arrays.copyOf(baos.toByteArray(), 28);
            String hex = ByteUtil.bytes2Hex((byte[])b).toUpperCase();
            Set keys = FileConstant.FILE_TYPE.keySet();
            for (String k : keys) {
                if (!hex.startsWith(k)) continue;
                key = k;
            }
            if (StringUtils.isBlank((String)key)) {
                throw new WrongArgException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301", "\u6587\u4ef6\u9b54\u6570\u503c", (Object)hex);
            }
            String fileType = (String)FileConstant.FILE_TYPE.get(key);
            String fileName = "file/" + this.buildExtraPath(extraPath) + UUID.randomUUID().toString().replace("-", "") + "." + fileType;
            this.getOssClient().putObject(Config.OSS_BUCKET_NAME, fileName, inputStream);
            FileInfo info = new FileInfo(inputStream, "http://img.thebeastshop.com/" + fileName);
            return info;
        }
        catch (WrongArgException e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
            throw new UnknownException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    public List<FileInfo> listFiles(String extraPath) {
        try {
            ObjectListing listing = this.getOssClient().listObjects(Config.OSS_BUCKET_NAME, "file/" + this.buildExtraPath(extraPath));
            LinkedList<FileInfo> list = new LinkedList<FileInfo>();
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                list.add(this.getFile("http://img.thebeastshop.com/" + objectSummary.getKey()));
            }
            return list;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5f02\u5e38: {}", (Throwable)e);
            throw new UnknownException("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    public FileInfo getFile(String fileUrl) {
        try {
            OSSObject ossObject = this.getOssClient().getObject(Config.OSS_BUCKET_NAME, this.getKey(fileUrl));
            FileInfo info = new FileInfo(ossObject.getObjectContent(), fileUrl);
            return info;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
            throw new UnknownException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    public void deleteFile(String fileUrl) {
        try {
            String key = this.getKey(fileUrl);
            this.getOssClient().deleteObject(Config.OSS_BUCKET_NAME, key);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
            throw new UnknownException("\u5220\u9664\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
    }

    private String getKey(String fileUrl) {
        return fileUrl.replace("http://img.thebeastshop.com/", "");
    }

    private String buildExtraPath(String extraPath) {
        if (StringUtils.isNotBlank((String)extraPath)) {
            extraPath = extraPath.indexOf("/") == 0 ? extraPath.substring(1) : extraPath;
            extraPath = extraPath + (extraPath.lastIndexOf("/") == -1 ? "/" : "");
        } else {
            extraPath = "";
        }
        return extraPath;
    }

    public static void main(String[] args) {
        FileServiceImpl service = new FileServiceImpl();
        service.listFiles("");
    }
}

